import _ from 'lodash';
import Promise from 'bluebird';
import { findMainCoatNodeSearchId } from 'ui/kibi/components/dashboards360/coat_tree';

export function DashboardHelperFactory($timeout, kbnUrl, kibiState, savedDashboards, savedSearches) {

  function DashboardHelper() {}

  /**
   * getTimeDependentDashboards returns a list of dashboards whose associated saved search is time-based.
   */
  DashboardHelper.prototype.getTimeDependentDashboards = function () {
    return savedDashboards.find()
      .then((savedDashboardsRes) => {
        const dashboards = _.filter(savedDashboardsRes.hits, (hit) => !!findMainCoatNodeSearchId(hit.coatJSON));
        const promises = _.map(dashboards, (dash) => {
          const savedSearchId = findMainCoatNodeSearchId(dash.coatJSON);
          return savedSearches.get(savedSearchId).catch(err => {
            return {
              cannotRetrieved: true,
              id: savedSearchId
            };
          });
        });
        return Promise.all(promises).then((savedSearchesRes) => {
          _.each(savedSearchesRes, (savedSearch) => {
            if (savedSearch.cannotRetrieved  || !savedSearch.searchSource.index().isTimeBased()) {
              for (let i = dashboards.length - 1; i >= 0; i--) {
                if (findMainCoatNodeSearchId(dashboards[i].coatJSON) === savedSearch.id) {
                  dashboards.splice(i, 1);
                }
              }
            }
          });
          return dashboards;
        });
      });
  };

  DashboardHelper.prototype._redirect = function (dashboardId) {
    // switch dashboard in the next tick. If the state (e.g., appState) is being changed, this would
    // invalidate the state of the new dashboard
    return $timeout(() => {
      kbnUrl.change('/dashboard/{{id}}', { id: dashboardId });
    });
  };

  /**
   * switchDashboard switches the view to the dashboard with the given ID
   */
  DashboardHelper.prototype.switchDashboard = function (dashboardId, activeGroupId) {
    if (activeGroupId) {
      kibiState.setSelectedDashboardId(activeGroupId, dashboardId);
    }
    return kibiState.saveAppState()
      .then(() => this._redirect(dashboardId));
  };

  return new DashboardHelper();
};
