export function bytesToHumanReadable(value) {
  if (value >= 1073741824) {
    value = "~" + (value / 1073741824).toFixed(2) + " GB";
  } else if (value >= 1048576) {
    value = "~" + (value / 1048576).toFixed(0) + " MB";
  } else if (value >= 1024) {
    value = "~" + (value / 1024).toFixed(0) + " KB";
  } else if (value > 1) {
    value = "~" + value + " bytes";
  } else if (value === 1) {
    value = "~" + value + " byte";
  } else {
    value = "0 bytes";
  };

  return value;
};