
/**
 * Takes an array of string and return the hash value.
 */
export function hash(args) {
  let h = 0;
  if (args.length === 1) {
    for (let i = 0; i < args[0].length; i++) {
      h = (h * 31 + args[0].charCodeAt(i)) & 0xffffffff;
    }
  } else {
    for (const k in args) {
      if (k) {
        const arg = args[k];
        if (arg) {
          h ^= hash([arg]);
        }
      }
    }
  }
  return h;
}
