import chrome from 'ui/chrome';
// kibi: #4881 OR multiselection patch - Start
import _ from 'lodash';

function cleanFilter(filter) {
  if (_.has(filter, 'query')) {
    return filter.query;
  }

  delete filter.meta;
  return filter;
}
// kibi: #4881 OR multiselection patch - End
define(function () {
  let i = 0;
  // kibi: #5647 backport of missing and others in term aggregations - Start
  function AggConfigResult(aggConfig, parent, value, key, filters) {
    this.filters = filters;
    // kibi: #5647 backport of missing and others in term aggregations - End
    this.key = _.get(aggConfig, 'params.field.esType') === 'boolean' ? !!key : key;
    this.value = value;
    this.aggConfig = aggConfig;
    this.$parent = parent;
    this.$order = ++i;

    if (aggConfig.schema.group === 'buckets') {
      this.type = 'bucket';
    } else {
      this.type = 'metric';
    }
  }

  /**
   * Returns an array of the aggConfigResult and parents up the branch
   * @returns {array} Array of aggConfigResults
   */
  AggConfigResult.prototype.getPath = function () {
    return (function walk(result, path) {
      path.unshift(result);
      if (result.$parent) return walk(result.$parent, path);
      return path;
    }(this, []));
  };

  // kibi: #4881 OR multiselection patch - Start
  AggConfigResult.prototype.createOthersBucketFilter = function () {
    let meta = {};
    const createdFilter = {
      query: {
        bool: {
          must: []
        }
      }
    };
    this.filters.forEach(function (filter) {
      if (filter.exists) {
        meta.value = `${meta.value ? meta.value + ', ' : ''}`
          + `${_.get(filter, 'meta.negate', false) ? '!' : ''}exists`;
      }
      if (filter.meta.negate) {
        createdFilter.query.bool.must.push({
          bool: {
            must_not: cleanFilter(filter)
          }
        });
        meta = Object.assign(meta, filter.meta);
        meta.negate = false;
      } else {
        meta = Object.assign(meta, filter.meta);
        createdFilter.query.bool.must.push(cleanFilter(filter));
      }
    });
    createdFilter.meta = meta;
    return createdFilter;
  };
  // kibi: #4881 OR multiselection patch - End

  /**
   * Returns an Elasticsearch filter that represents the result.
   * @returns {object} Elasticsearch filter
   */
  AggConfigResult.prototype.createFilter = function () {
    // kibi: #4881 OR multiselection patch - Start
    if (this.filters && this.filters.length > 1) {
      return this.createOthersBucketFilter();
    }
    // kibi: #4881 OR multiselection patch - End
    // kibi: #5647 backport of missing and others in term aggregations - Start
    return this.filters || this.aggConfig.createFilter(this.key);
    // kibi: #5647 backport of missing and others in term aggregations - End
  };

  AggConfigResult.prototype.toString = function (contentType) {
    const parsedUrl = {
      origin: window.location.origin,
      pathname: window.location.pathname,
      basePath: chrome.getBasePath(),
    };
    return this.aggConfig.fieldFormatter(contentType)(this.value, null, null, parsedUrl);
  };

  AggConfigResult.prototype.valueOf = function () {
    return this.value;
  };

  return AggConfigResult;
});
