import _ from 'lodash';
import ScatterPlotAggSelectorTemplate from './scatterplot_agg_selector.html';
import { uiModules } from 'ui/modules';

const module = uiModules.get('kibana/scatterplot_vis');

module.directive('scatterplotAggSelector', function () {
  return {
    scope: {
      model: '=',
      fields: '=',
      exclude: '='
    },
    restrict: 'E',
    template: ScatterPlotAggSelectorTemplate,
    link: function ($scope, $element, attrs) {

      $scope.aggTypes = [{
        name: 'date_histogram',
        title: 'Date Histogram'
      }, {
        name: 'histogram',
        title: 'Histogram'
      }, {
        name: 'range',
        title: 'Range',
      }, {
        name: 'date_range',
        title: 'Date Range',
      }, {
        name: 'terms',
        title: 'Terms',
      }, {
        name: 'filters',
        title: 'Filters',
      }, {
        name: 'significant_terms',
        title: 'Significant Terms',
      }];

      const excludes = $scope.exclude.split(',');
      $scope.aggTypes = $scope.aggTypes.filter(function (t) {
        return _.indexOf(excludes, t.name) < 0;
      });

      const fields = _.sortBy($scope.fields, 'name');

      $scope.listFields = fields.filter(function (f) {
        return f.filterable === true && (
          f.type === 'string' || f.type === 'number' || f.type === 'date' ||
          f.type === 'boolean'
        );
      });

      $scope.nonScriptedFields = $scope.listFields.filter(function (f) {
        return f.scripted === false;
      });

      $scope.listNumericFields = fields.filter(function (f) {
        return f.filterable === true && f.type === 'number';
      });

      $scope.dateFields = fields.filter(function (f) {
        return f.filterable === true && f.type === 'date';
      });

      $scope.intervals = [{
        name: 'auto',
        displayName: 'Auto'
      }];

    }
  };
});
