import _ from 'lodash';
import scatterPlotMetricSelectorTemplate from './scatterplot_metric_selector.html';
import { uiModules } from 'ui/modules';

const module = uiModules.get('kibana/scatterplot_vis');

module.directive('scatterplotMetricSelector', function () {
  return {
    scope: {
      model: '=',
      fields: '=',
      exclude: '='
    },
    restrict: 'E',
    template: scatterPlotMetricSelectorTemplate,
    link: function ($scope, $element, attrs) {

      $scope.metricTypes = [{
        name: 'count',
        title: 'Count'
      }, {
        name: 'avg',
        title: 'Average'
      }, {
        name: 'sum',
        title: 'Sum',
      }, {
        name: 'median',
        title: 'Median',
      }, {
        name: 'min',
        title: 'Min',
      }, {
        name: 'max',
        title: 'Max',
      }, {
        name: 'cardinality',
        title: 'Unique Count',
      }, {
        name: 'percentiles',
        title: 'Percentiles',
      }, {
        name: 'percentile_ranks',
        title: 'Percentile Ranks',
      }];

      let excludes = $scope.exclude.split(',');
      $scope.metricTypes = $scope.metricTypes.filter(function (t) {
        return _.indexOf(excludes, t.name) < 0;
      });

      const fields = _.sortBy($scope.fields, 'name');

      $scope.listFields = fields.filter(function (f) {
        return f.filterable === true && (
          f.type === 'string' || f.type === 'number' || f.type === 'date' ||
          f.type === 'boolean'
        );
      });

      $scope.listNumericFields = fields.filter(function (f) {
        return f.filterable === true && f.type === 'number';
      });

      $scope.dateFields = fields.filter(function (f) {
        return f.filterable === true && f.type === 'date';
      });

      $scope.listNumDateFields = fields.filter(function (f) {
        return f.filterable === true && (f.type === 'number' || f.type === 'date');
      });

    }
  };
});
