import _ from 'lodash';
import moment from 'moment';
import { cleanFilter } from 'ui/kibi/components/dashboards360/lib/clean_filter';
import { translateToQuery } from 'ui/kibi/components/dashboards360/lib/translate_to_query';

export function getSearchParameters(
  scope, timefilter,
  appFilters = [], appQuery,
  ssFilters = [], ssQuery
  ) {
  let mustFilters = [];
  let mustNotFilters = [];
  appFilters.forEach(function (filter) {
    if (!filter.meta.disabled) {
      if (!filter.meta.negate) {
        mustFilters.push(cleanFilter(filter));
      } else {
        mustNotFilters.push(cleanFilter(filter));
      }
    }
  });

  ssFilters.forEach(function (filter) {
    if (!filter.meta.disabled) {
      if (!filter.meta.negate) {
        mustFilters.push(cleanFilter(filter));
      } else {
        mustNotFilters.push(cleanFilter(filter));
      }
    }
  });

  mustFilters.push(timefilter.get(scope.vis.indexPattern));

  let queryFilters = {
    bool: {
      must: mustFilters.map(translateToQuery),
      must_not: mustNotFilters.map(translateToQuery)
    }
  };

  let fieldParams = _.uniq([
    scope.options.xFieldName,
    scope.options.yFieldName,
    scope.options.labelFieldName,
    scope.options.colorFieldName,
    scope.options.dotSizeFieldName,
    scope.options.xJitterFieldName
  ]);
  fieldParams = _.map(fieldParams, field => _.trim(field));
  let dottedField = _.filter(fieldParams, field => field.split('.').length > 1);
  fieldParams = _.remove(fieldParams, field => {
    return field !== '' && field.split('.').length === 1;
  });

  let searchSize = scope.options.dataSize;
  let aggParam = {};
  let scriptedFields = {};
  let indexFields = scope.vis.indexPattern.fields;

  function addFieldTo(obj, field) {
    let sf;
    if (field.scripted) {
      sf = {
        script: {
          inline: field.script,
          lang: field.lang
        }
      };
    } else {
      sf = {
        field: field.name
      };
    }
    _.merge(obj, sf);
  }

  if (scope.options.aggMode === 'Straight data') {
    _.forEach(fieldParams, f => {
      let field = indexFields.byName[f];
      if (field && field.scripted) {
        let sf = {
          script: {
            inline: field.script,
            lang: field.lang
          }
        };
        scriptedFields[f] = sf;
      }
    });
  }

  if (scope.options.aggMode === 'Significant term data') {
    searchSize = 0;
    aggParam = {
      '2': {
        significant_terms: {
          field: scope.options.stFieldName,
          size: scope.options.stSize
        }
      }
    };
  }

  if (scope.options.aggMode === 'Filtered aggregator data') {

    let aggObj;
    let bounds = timefilter.getActiveBounds();

    if (scope.options.faBucket.name === 'date_histogram') {
      aggObj = {
        date_histogram: {
          field: scope.options.faBucket.fieldName,
          interval: '1M',
          min_doc_count: 1,
          extended_bounds: {
            min: moment(bounds.min).valueOf(),
            max: moment(bounds.max).valueOf()
          }
        }
      };
    } else if (scope.options.faBucket.name === 'histogram') {
      aggObj = {
        histogram: {
          interval: scope.options.faBucket.numInterval
        }
      };
      addFieldTo(aggObj.histogram, scope.options.faBucket.field);
    } else if (scope.options.faBucket.name === 'terms') {
      aggObj = {
        terms: {
          size: scope.options.faBucket.size,
          order: {
            '_term': 'asc'
          }
        }
      };
      addFieldTo(aggObj.terms, scope.options.faBucket.field);
    } else if (scope.options.faBucket.name === 'significant_terms') {
      aggObj = {
        significant_terms: {
          field: scope.options.faBucket.fieldName,
          size: scope.options.faBucket.size
        }
      };
    }

    searchSize = 0;

    let metricObj = {};
    if (scope.options.faMetric.name === 'count') {
      metricObj = {};
    } else if (scope.options.faMetric.name === 'avg') {
      metricObj = { aggs: { '1': { avg: { } } } };
      addFieldTo(metricObj.aggs['1'].avg, scope.options.faMetric.field);
    } else if (scope.options.faMetric.name === 'sum') {
      metricObj = { aggs: { '1': { sum: { } } } };
      addFieldTo(metricObj.aggs['1'].sum, scope.options.faMetric.field);
    } else if (scope.options.faMetric.name === 'min') {
      metricObj = { aggs: { '1': { min: { } } } };
      addFieldTo(metricObj.aggs['1'].min, scope.options.faMetric.field);
    } else if (scope.options.faMetric.name === 'max') {
      metricObj = { aggs: { '1': { max: { } } } };
      addFieldTo(metricObj.aggs['1'].max, scope.options.faMetric.field);
    } else if (scope.options.faMetric.name === 'cardinality') {
      metricObj = { aggs: { '1': { cardinality: { } } } };
      addFieldTo(metricObj.aggs['1'].cardinality, scope.options.faMetric.field);
    }

    aggParam = {
      '2': {
        aggs: {
          '3': {
            filters: {
              filters: {
                x: {
                  bool: {
                    must: {
                      query_string: {
                        query: scope.options.faFilterX,
                        analyze_wildcard: true
                      }
                    }
                  }
                },
                y: {
                  bool: {
                    must: {
                      query_string: {
                        query: scope.options.faFilterY,
                        analyze_wildcard: true
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    };
    _.merge(aggParam['2'], aggObj);
    _.merge(aggParam['2'].aggs['3'], metricObj);
  }

  if (scope.options.aggMode === 'Any aggregator data') {

    let aggObj;
    let bounds = timefilter.getActiveBounds();

    if (scope.options.aaBucket.name === 'date_histogram') {
      aggObj = {
        date_histogram: {
          field: scope.options.aaBucket.fieldName,
          interval: '1M',
          min_doc_count: 1,
          extended_bounds: {
            min: moment(bounds.min).valueOf(),
            max: moment(bounds.max).valueOf()
          }
        }
      };
    } else if (scope.options.aaBucket.name === 'histogram') {
      aggObj = {
        histogram: {
          interval: scope.options.aaBucket.numInterval
        }
      };
      addFieldTo(aggObj.histogram, scope.options.aaBucket.field);
    } else if (scope.options.aaBucket.name === 'terms') {
      aggObj = {
        terms: {
          size: scope.options.aaBucket.size,
          order: {
            '_term': 'asc'
          }
        }
      };
      addFieldTo(aggObj.terms, scope.options.aaBucket.field);
    } else if (scope.options.aaBucket.name === 'significant_terms') {
      aggObj = {
        significant_terms: {
          field: scope.options.aaBucket.fieldName,
          size: scope.options.aaBucket.size
        }
      };
    }

    searchSize = 0;

    let xmetricObj = {};
    if (scope.options.aaXmetric.name === 'count') {
      xmetricObj = {};
    } else if (scope.options.aaXmetric.name === 'avg') {
      xmetricObj = { aggs: { '1': { avg: { } } } };
      addFieldTo(xmetricObj.aggs['1'].avg, scope.options.aaXmetric.field);
    } else if (scope.options.aaXmetric.name === 'sum') {
      xmetricObj = { aggs: { '1': { sum: { } } } };
      addFieldTo(xmetricObj.aggs['1'].sum, scope.options.aaXmetric.field);
    } else if (scope.options.aaXmetric.name === 'min') {
      xmetricObj = { aggs: { '1': { min: { } } } };
      addFieldTo(xmetricObj.aggs['1'].min, scope.options.aaXmetric.field);
    } else if (scope.options.aaXmetric.name === 'max') {
      xmetricObj = { aggs: { '1': { max: { } } } };
      addFieldTo(xmetricObj.aggs['1'].max, scope.options.aaXmetric.field);
    } else if (scope.options.aaXmetric.name === 'cardinality') {
      xmetricObj = { aggs: { '1': { cardinality: { } } } };
      addFieldTo(xmetricObj.aggs['1'].cardinality, scope.options.aaXmetric.field);
    }

    let ymetricObj = {};
    if (scope.options.aaYmetric.name === 'count') {
      ymetricObj = {};
    } else if (scope.options.aaYmetric.name === 'avg') {
      ymetricObj = { aggs: { '3': { avg: { } } } };
      addFieldTo(ymetricObj.aggs['3'].avg, scope.options.aaYmetric.field);
    } else if (scope.options.aaYmetric.name === 'sum') {
      ymetricObj = { aggs: { '3': { sum: { } } } };
      addFieldTo(ymetricObj.aggs['3'].sum, scope.options.aaYmetric.field);
    } else if (scope.options.aaYmetric.name === 'min') {
      ymetricObj = { aggs: { '3': { min: { } } } };
      addFieldTo(ymetricObj.aggs['3'].min, scope.options.aaYmetric.field);
    } else if (scope.options.aaYmetric.name === 'max') {
      ymetricObj = { aggs: { '3': { max: { } } } };
      addFieldTo(ymetricObj.aggs['3'].max, scope.options.aaYmetric.field);
    } else if (scope.options.aaYmetric.name === 'cardinality') {
      ymetricObj = { aggs: { '3': { cardinality: { } } } };
      addFieldTo(ymetricObj.aggs['3'].cardinality, scope.options.aaYmetric.field);
    }

    aggParam = { '2': { } };

    _.merge(aggParam['2'], aggObj);
    _.merge(aggParam['2'], xmetricObj);
    _.merge(aggParam['2'], ymetricObj);
  }
  if (appQuery) {
    queryFilters.bool.must.push(appQuery);
  }
  if (ssQuery) {
    queryFilters.bool.must.push(ssQuery);
  }

  let body = {
    _source: fieldParams,
    docvalue_fields: dottedField,
    query: {
      function_score: {
        query: queryFilters,
        functions: [{
          random_score: { }
        }],
        boost_mode: 'replace'
      }
    }
  };

  if (_.size(aggParam) > 0) {
    body.aggs = aggParam;
  }

  if (_.size(scriptedFields) > 0) {
    body.script_fields = scriptedFields;
  }

  return {
    index: scope.vis.indexPattern.title,
    body: body,
    size: searchSize
  };
};
