import 'plugins/scatterplot_vis/scatterplot_vis.less';
import 'plugins/scatterplot_vis/scatterplot_vis_controller';
import 'plugins/scatterplot_vis/scatterplot_vis_params';
import 'plugins/scatterplot_vis/scatterplot';
import { VisVisTypeProvider } from 'ui/vis/vis_type';
import scatterPlotVisTemplate from 'plugins/scatterplot_vis/scatterplot_vis.html';
import { TemplateVisTypeProvider } from 'ui/template_vis_type/template_vis_type';
import { VisTypesRegistryProvider } from 'ui/registry/vis_types';

function ScatterPlotVisProvider(Private) {
  const VisType = Private(VisVisTypeProvider);
  const TemplateVisType = Private(TemplateVisTypeProvider);

  return new TemplateVisType({
    name: 'scatterplot_vis',
    title: 'Scatter Plot',
    description: 'Scatter Plot Chart widget',
    icon: 'fcp-scatterplot',
    category: VisType.CATEGORY.INDIVIDUAL,
    template: scatterPlotVisTemplate,
    params: {
      defaults: {
        xFieldName: '',
        yFieldName: '',
        xJitterFieldName: '',
        xJitterScale: 'linear',
        labelFieldName: '',
        color: '',
        colorFieldName: '',
        dotSizeFieldName: '',
        dotSize: 8,
        dotSizeScale: 'square root',
        labelEnabled: false,
        labelHoverEnabled: false,
        sizeParam: 500,
        xAxisLabel: '',
        yAxisLabel: '',
        xAxisScale: 'linear',
        yAxisScale: 'linear',
        aggMode: 'Straight data',
        stFieldName: '',
        stSize: 0,
        handleNoResults: true,
        shapeOpacity: 0.7,
        faBucket: '',
        faFilterX: '',
        faFilterY: '',
        faMetric: '',
        aaBucket: '',
        aaXmetric: '',
        aaYmetric: ''
      },
      editor: '<scatterplot-vis-params></scatterplot-vis-params>'
    },
    defaultSection: 'options',
    init: function (vis, savedSearch) {
      vis.savedSearchId = savedSearch.id;
    }
  });
}

VisTypesRegistryProvider.register(ScatterPlotVisProvider);

export default ScatterPlotVisProvider;
