'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _fs = require('fs');

var _utils = require('../../utils');

const getConfigYmlPath = (filename, dev) => {
  return (0, _utils.fromRoot)(`config/${filename}${dev ? '.dev' : ''}.yml`);
};

const getConfigFilename = (filename, dev) => {
  return `${filename}${dev ? '.dev' : ''}.yml`;
};

function checkConfigYmlExists(filename, dev) {
  const kibiYmlPath = getConfigYmlPath(filename, dev);
  return (0, _fs.existsSync)(kibiYmlPath);
}

exports.default = {
  checkConfigYmlExists,
  getConfigFilename,
  getConfigYmlPath
};
module.exports = exports['default'];
