'use strict';

var _setup_error = require('./setup_error');

var _setup_error2 = _interopRequireDefault(_setup_error);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

module.exports = function (server, mappings) {
  const { callWithInternalUser } = server.plugins.elasticsearch.getCluster('admin');
  const index = server.config().get('kibana.index');

  function handleError(message) {
    return function (err) {
      throw new _setup_error2.default(server, message, err);
    };
  }
  return callWithInternalUser('indices.create', {
    index: index,
    body: {
      settings: {
        number_of_shards: 1
      },
      mappings
    }
  })
  // kibi: renamed Kibana to Investigate
  .catch(handleError('Unable to create Siren Investigate index "<%= kibana.index %>"')).then(function () {
    return callWithInternalUser('cluster.health', {
      waitForStatus: 'yellow',
      index: index
    }).catch(handleError('Waiting for Siren Investigate index "<%= kibana.index %>" to come online failed.'));
  });
};
