'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _upgrade_config = require('./upgrade_config');

var _upgrade_config2 = _interopRequireDefault(_upgrade_config);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports.default = async function (server) {
  const savedObjectsClient = server.savedObjectsClientFactory({
    callCluster: server.plugins.elasticsearch.getCluster('admin').callWithInternalUser
  });

  const { saved_objects: configSavedObjects } = await savedObjectsClient.find({
    type: 'config',
    page: 1,
    perPage: 1000,
    sortField: 'buildNum',
    sortOrder: 'desc'
  });

  return await (0, _upgrade_config2.default)(server, savedObjectsClient)(configSavedObjects);
};

module.exports = exports['default'];
