import _ from 'lodash';
import React from 'react';
import { render, unmountComponentAtNode } from 'react-dom';
import { uiModules } from 'ui/modules';
import { ControlsTab } from 'plugins/input_control_vis/components/editor/controls_tab';
import { InjectAPI } from 'plugins/input_control_vis/wrapper/helpers/inject_api';

uiModules
  .get('kibana/input_control_vis')
  .directive('kbnInputControlVisControlsTabDirective', function (Private, indexPatterns, timefilter, $compile) {
    const injectAPI = new InjectAPI(Private, indexPatterns, timefilter);
    function link($scope, $el) {
      injectAPI.injectAPIs($scope);

      const editorComponent = ControlsTab;
      const stageEditorParams = (params) => {
        $scope.vis.params = _.cloneDeep(params);
        $scope.$apply();
      };
      const renderReactComponent = () => {
        const Component = editorComponent;
        render(<Component scope={$scope} stageEditorParams={stageEditorParams} />, $el[0]);
      };

      renderReactComponent();

      $scope.$watchGroup(['visData', 'visualizeEditor', 'vis.params'], () => {
        renderReactComponent();      });

      $scope.$watch('vis.type.schemas.all.length', function (len) {
        $scope.alwaysShowOptions = len === 0;
      });

      $el.on('$destroy', () => {
        unmountComponentAtNode($el[0]);
      });
    };
    return {
      restrict: 'E',
      scope: {
        vis: '=',
        visData: '=',
        uiState: '=',
        visualizeEditor: '='
      },
      link: link
    };
  });
