import _ from 'lodash';
import { uiModules } from 'ui/modules';
import chrome from 'ui/chrome';
import angular from 'angular';
import { toJson } from 'ui/utils/aggressive_parse';
import translateJoinQueryTemplate from '../partials/translate_join_query.html';
import '../styles/translate_join_query.less';

const app = uiModules.get('kibana');
app.directive('translateJoinQuery', function ($http) {
  return {
    template: translateJoinQueryTemplate,
    scope: true,
    controller: function ($scope, timefilter) {
      timefilter.enabled = false;

      // example queries
      const sampleQuery = {
        query: {
          join_sequence: [
            {
              relation: [
                {
                  pattern: 'INDEX-PATTERN2',
                  path: 'FIELD2',
                  indices: ['INDEX-PATTERN2'],
                  queries: [
                    {
                      match_all: {}
                    }
                  ]
                },
                {
                  pattern: 'INDEX-PATTERN1',
                  path: 'FIELD1',
                  indices: ['INDEX-PATTERN1']
                }
              ]
            }
          ]
        }
      };
      $scope.rawQuery = JSON.stringify(sampleQuery, null, ' ');

      const sampleMsearchQuery =
        '{"index":["INDEX-PATTERN1"],"ignore_unavailable":true,"preference":1526038482946}\n' +
        JSON.stringify(sampleQuery) + '\n';
      $scope.rawMsearchQuery = sampleMsearchQuery + sampleMsearchQuery;

      $scope.aceLoaded = function (editor) {
        $scope.editor = editor;
      };

      $scope.aceLoadedMsearch = function (editor) {
        $scope.msearchEditor = editor;
      };

      $scope.translate = function () {
        $http.post(chrome.getBasePath() + '/translateToES',  {
          query: JSON.parse($scope.rawQuery)
        })
          .then(result => {
            const search = 'GET siren/INDEX/_search\n' + JSON.stringify(result.data.translatedQuery);
            $scope.translatedRawQuery = search;
            $scope.editor.setValue(JSON.stringify(result.data.translatedQuery, null, 2));
          });
      };

      $scope.clear = function () {
        $scope.translatedRawQuery = '';
        $scope.editor.setValue('');
      };

      $scope.translateMsearch = function () {

        // first split by new lines
        const lines = $scope.rawMsearchQuery.split(/\n\r?/);
        // remove emty lines
        const filterted = _(lines).filter(line => {
          return _.trim(line) !== '';
        }).value();

        // must be even
        if (filterted.length % 2 !== 0) {
          throw new Error('Something wrong with your msearch');
        }

        // translate queries
        const promises = [];
        for (let i = 0; i < filterted.length; i++) {
          if (i % 2 === 0) {
            // meta
            promises.push(filterted[i]);
          } else {
            promises.push($http.post(chrome.getBasePath() + '/translateToES',  {
              query: JSON.parse(filterted[i])
            }));
          }
        }

        Promise.all(promises).then(lines => {
          let msearch = 'POST siren/_msearch\n';
          let formattedMsearch = '';
          _.each(lines, line => {
            if (line.data && line.data.translatedQuery) {
              msearch += JSON.stringify(line.data.translatedQuery) + '\n';
              formattedMsearch += JSON.stringify(line.data.translatedQuery, null, ' ') + '\n';
            } else {
              msearch += line + '\n';
              formattedMsearch += line + '\n';
            }
          });

          $scope.translatedRawMsearchQuery = msearch;
          $scope.msearchEditor.setValue(formattedMsearch);
        });
      };

      $scope.clearMsearch = function () {
        $scope.translatedRawMsearchQuery = '';
        $scope.msearchEditor.setValue('');
      };

    }
  };
});
