import _ from 'lodash';
import './index_header';
import './indexed_fields_table';
import './scripted_fields_table';
import './scripted_field_editor';
import './source_filters_table';
// kibi: removed RefreshKibanaIndex as in Investigate refresh is done by saved object API
import UrlProvider from 'ui/url';
import { IndicesEditSectionsProvider } from './edit_sections';
import uiRoutes from 'ui/routes';
import { uiModules } from 'ui/modules';
import template from './edit_index_pattern.html';

// kibi: Added imports
import { IndexPatternAuthorizationError } from 'ui/errors';
// kibi: end

uiRoutes
  .when('/management/siren/indices/:indexPatternId', {
    template,
    resolve: {
    // kibi: virtual index can be unavailable, investigate should display error and redirect
      indexPattern: function ($route, courier, mappings, kbnUrl, createNotifier, config) {
        return courier.indexPatterns
          .get($route.current.params.indexPatternId)
          .catch(err => {
            const defaultIndex = config.get('defaultIndex');
            mappings.clearCache();
            courier.indexPatterns.cache.delete($route.current.params.indexPatternId);
            createNotifier({ location: 'edit index pattern' }).error(err);
            if (defaultIndex) {
              return kbnUrl.change(`/management/siren/indices/${defaultIndex}`);
            } else {
              return kbnUrl.change('/management/siren/index');
            }
          });
      }
    // kibi: end
    }
  });

uiRoutes
  .when('/management/siren/indices', {
    resolve: {
      redirect: function ($location, config) {
        const defaultIndex = config.get('defaultIndex');
        let path = '/management/siren/index';

        if (defaultIndex) {
          path = `/management/siren/indices/${defaultIndex}`;
        }

        $location.path(path).replace();
      }
    }
  });

uiModules.get('apps/management')
  .controller('managementIndicesEdit', function (
    $scope, $location, $route, config, courier, createNotifier,
    Private, AppState, docTitle, confirmModal, dataModel, kbnUrl, $timeout) {

    const notify = createNotifier({ location: 'Edit index pattern' });
    const $state = $scope.state = new AppState();
    // kibi: removed RefreshKibanaIndex as in Investigate refresh is done by saved object API

    $scope.kbnUrl = Private(UrlProvider);
    $scope.indexPattern = $route.current.locals.indexPattern;
    docTitle.change($scope.indexPattern.title);

    docTitle.change($scope.indexPattern.id);
    const otherIds = _.without($route.current.locals.indexPatternIds, $scope.indexPattern.id);

    const otherPatterns = _.filter($route.current.locals.indexPatterns, pattern => {
      return pattern.id !== $scope.indexPattern.id;
    });

    $scope.$watch('indexPattern.fields', function () {
      $scope.editSections = Private(IndicesEditSectionsProvider)($scope.indexPattern);
      $scope.refreshFilters();
    });

    $scope.refreshFilters = function () {
      const indexedFieldTypes = [];
      const scriptedFieldLanguages = [];
      if ($scope.indexPattern.fields) {
        $scope.indexPattern.fields.forEach(field => {
          if (field.scripted) {
            scriptedFieldLanguages.push(field.lang);
          } else {
            indexedFieldTypes.push(field.type);
          }
        });
      }

      $scope.indexedFieldTypes = _.uniq(indexedFieldTypes);
      $scope.scriptedFieldLanguages = _.uniq(scriptedFieldLanguages);
    };

    $scope.changeFilter = function (filter, val) {
      $scope[filter] = val || ''; // null causes filter to check for null explicitly
    };

    $scope.changeTab = function (obj) {
      $state.tab = obj.index;
      $state.save();

      // kibi: Added alternate fingerprints view
      $scope.tabView = 'default';
    };

    $scope.$watch('state.tab', function (tab) {
      if (!tab && $scope.editSections) $scope.changeTab($scope.editSections[0]);
    });

    $scope.$watchCollection('indexPattern.fields', function () {
      if ($scope.indexPattern.fields) {
        $scope.conflictFields = $scope.indexPattern.fields
          .filter(field => field.type === 'conflict');
      }
    });

    $scope.refreshFields = function () {
      const confirmModalOptions = {
        confirmButtonText: 'Refresh fields',
        onConfirm: () => { $scope.indexPattern.refreshFields(); }
      };
      confirmModal(
        'This will reset the field popularity counters. Are you sure you want to refresh your fields?',
        confirmModalOptions
      );
    };

    const deleteEntityAndRelationsAndRedirect = (entityId) => {
      return Promise.all([
        dataModel.deleteSearch(entityId),
        dataModel.deleteRelationsByDomainOrRange(entityId)
      ])
        .then(kbnUrl.change('/management/siren/indexesandrelations'));
    };

    $scope.removePattern = function () {
      function doRemove() {
      // kibi: here is fine to use config.get('defaultIndex')
      // if user do not have rights s/he will get an authorisation error
        if ($scope.indexPattern.id === config.get('defaultIndex')) {
          config.remove('defaultIndex');

          if (otherPatterns.length) {
            config.set('defaultIndex', otherPatterns[0].id);
          }
        }

        courier.indexPatterns.delete($scope.indexPattern)
          .then(function () {
            $location.url('/management/siren/indices');
          })
          .catch(notify.error);
      }

      const confirmModalOptions = {
        confirmButtonText: 'Remove index pattern',
        onConfirm: doRemove
      };
      confirmModal('Are you sure you want to remove this index pattern?', confirmModalOptions);
    };


    $scope.setDefaultPattern = function () {
      config.set('defaultIndex', $scope.indexPattern.id);
    };

    $scope.setIndexPatternsTimeField = function (field) {
      if (field.type !== 'date') {
        notify.error('That field is a ' + field.type + ' not a date.');
        return;
      }
      $scope.indexPattern.timeFieldName = field.name;
      return $scope.indexPattern.save();
    };

  });
