import React from 'react';
import { shallow } from 'enzyme';
import GaugeSeries from './series';

const props = {
  className: 'ui-sortable-item',
  colorPicker: true,
  disableAdd: true,
  disableDelete: true,
  fields: {
    '*': [
      {
        name: 'actiongroups.keyword',
        type: 'string',
        esType: 'keyword',
        searchable: true,
        aggregatable: true,
        readFromDocValues: true
      },
      {
        name: 'affiliation_name',
        type: 'string',
        esType: 'keyword',
        searchable: true,
        aggregatable: true,
        readFromDocValues: true
      },
      {
        name: 'web_presence',
        type: 'string',
        esType: 'keyword',
        searchable: true,
        aggregatable: true,
        readFromDocValues: true
      },
      {
        name: 'web_presence.raw',
        type: 'string',
        esType: 'keyword',
        searchable: true,
        aggregatable: true,
        readFromDocValues: true
      }
    ]
  },
  name: 'metrics',
  model: {
    id: '03d5b5d0-231a-11e9-86f5-49991dc5ba79',
    color: '#68BC00',
    split_mode: 'everything',
    metrics: [
      {
        id: '03d5b5d1-231a-11e9-86f5-49991dc5ba79',
        type: 'count'
      },
      {
        id: '0924f690-231a-11e9-86f5-49991dc5ba79',
        type: 'count'
      }
    ],
    seperate_axis: 0,
    axis_position: 'right',
    formatter: 'number',
    chart_type: 'line',
    line_width: 1,
    point_size: 1,
    fill: 0.5,
    stacked: 'none'
  },
  panel: {
    id: '03d58ec0-231a-11e9-86f5-49991dc5ba79',
    type: 'gauge',
    series: [
      {
        id: '03d5b5d0-231a-11e9-86f5-49991dc5ba79',
        color: '#68BC00',
        split_mode: 'everything',
        metrics: [
          {
            id: '03d5b5d1-231a-11e9-86f5-49991dc5ba79',
            type: 'count'
          },
          {
            id: '0924f690-231a-11e9-86f5-49991dc5ba79',
            type: 'count'
          }
        ],
        seperate_axis: 0,
        axis_position: 'right',
        formatter: 'number',
        chart_type: 'line',
        line_width: 1,
        point_size: 1,
        fill: 0.5,
        stacked: 'none'
      }
    ],
    time_field: '@timestamp',
    index_pattern: '*',
    interval: 'auto',
    axis_position: 'left',
    axis_formatter: 'number',
    show_legend: 1,
    background_color_rules: [
      {
        id: 'f0272160-2321-11e9-afe0-65aa43fcba24'
      }
    ]
  },
  selectedTab: 'metrics',
  sortData: '03d5b5d0-231a-11e9-86f5-49991dc5ba79',
  style: {
  },
  visible: true
};

test('renders', () => {
  const component = shallow(<GaugeSeries {...props} />);
  expect(component).toMatchSnapshot(); // eslint-disable-line
});