import React from 'react';
import { shallow } from 'enzyme';
import GaugeVisualization from './vis';

const props = {
  backgroundColor: '#FFF',
  model: {
    id: '03d58ec0-231a-11e9-86f5-49991dc5ba79',
    type: 'gauge',
    series: [
      {
        id: '03d5b5d0-231a-11e9-86f5-49991dc5ba79',
        color: '#68BC00',
        split_mode: 'everything',
        metrics: [
          {
            id: '03d5b5d1-231a-11e9-86f5-49991dc5ba79',
            type: 'count'
          },
          {
            id: '0924f690-231a-11e9-86f5-49991dc5ba79',
            type: 'count'
          }
        ],
        seperate_axis: 0,
        axis_position: 'right',
        formatter: 'number',
        chart_type: 'line',
        line_width: 1,
        point_size: 1,
        fill: 0.5,
        stacked: 'none'
      }
    ],
    time_field: '@timestamp',
    index_pattern: '*',
    interval: 'auto',
    axis_position: 'left',
    axis_formatter: 'number',
    show_legend: 1,
    background_color_rules: [
      {
        id: 'f0272160-2321-11e9-afe0-65aa43fcba24'
      }
    ],
    gauge_color_rules: [
      {
        id: '049ae0f0-2322-11e9-afe0-65aa43fcba24'
      }
    ],
    gauge_width: 10,
    gauge_inner_width: 10,
    gauge_style: 'half'
  },
  visData: {
    '03d58ec0-231a-11e9-86f5-49991dc5ba79': {
      id: '03d58ec0-231a-11e9-86f5-49991dc5ba79',
      series: [
        {
          id: '03d5b5d0-231a-11e9-86f5-49991dc5ba79',
          label: 'Count',
          color: '#68BC00',
          data: [
            [
              1548696240000,
              2
            ],
            [
              1548696250000,
              5
            ]
          ],
          stack: false,
          lines: {
            show: true,
            fill: 0.5,
            lineWidth: 1,
            steps: false
          },
          points: {
            show: true,
            radius: 1,
            lineWidth: 1
          },
          bars: {
            show: false,
            fill: 0.5,
            lineWidth: 1
          }
        }
      ]
    }
  }
};

test('renders', () => {
  const component = shallow(<GaugeVisualization {...props} />);
  expect(component).toMatchSnapshot(); // eslint-disable-line
});