import { find } from 'lodash';
import $ from 'jquery';
export default function TileMapTooltipFormatter($compile, $rootScope) {

  const $tooltipScope = $rootScope.$new();
  const $el = $('<div>').html(require('./tooltip.html'));
  $compile($el)($tooltipScope);

  return function tooltipFormatter(metricAgg, metric, fieldName) {

    if (!metric) {
      return '';
    }

    let metricValue;
    if (fieldName) {
      // metricAgg is not about label field, that's why we need to fetch index pattern
      const indexPattern = metricAgg.getIndexPattern();
      const field = find(indexPattern.fields, function (item) {
        return item.displayName === fieldName.split(':')[0];
      });
      if (field && field.format) {
        metricValue = field.format.convert(metric.term, 'html');
      }
    }

    $tooltipScope.details = [];
    if (fieldName && metric) {
      $tooltipScope.details.push({
        label: fieldName,
        value: metricValue || metric.term
      });
    }

    if (metric) {
      $tooltipScope.details.push({
        label: metricAgg.makeLabel(),
        value: metricAgg.fieldFormatter('html')(metric.value)
      });
    }

    $tooltipScope.$apply();
    return $el.html();
  };
}
