import $ from 'jquery';

const app = require('ui/modules').get('apps/timelion', []);
app.directive('fixedElementRoot', function () {
  return {
    restrict: 'A',
    link: function ($scope, $elem, $window) {
      let fixedAt;

      const $windowEl = $(window);
      const scrollHandler = function () {
        const fixed = $('[fixed-element]', $elem);
        const body = $('[fixed-element-body]', $elem);
        const top = fixed.offset().top;

        if ($windowEl.scrollTop() > top) {
          // This is a gross hack, but its better than it was. I guess
          fixedAt = $windowEl.scrollTop();
          fixed.addClass(fixed.attr('fixed-element'));
          body.addClass(fixed.attr('fixed-element-body'));
          body.css({ top: fixed.height() });
        }

        if ($windowEl.scrollTop() < fixedAt) {
          fixed.removeClass(fixed.attr('fixed-element'));
          body.removeClass(fixed.attr('fixed-element-body'));
          body.removeAttr('style');
        }
      };

      $windowEl.on('scroll', scrollHandler);

      $scope.$on('$destroy', function () {
        $windowEl.off('scroll', scrollHandler);
      });
    }
  };
});
