import { SavedObjectLoader } from 'ui/courier/saved_object/saved_object_loader';
// kibi: added cache_helper
import { CacheProvider } from 'ui/kibi/helpers/cache_helper';
import { savedObjectManagementRegistry } from 'plugins/kibana/management/saved_object_registry';

define(function (require) {
  const module = require('ui/modules').get('app/sheet');
  // bring in the factory
  require('./_saved_sheet.js');

  // Register this service with the saved object registry so it can be
  // edited by the object editor.
  savedObjectManagementRegistry.register({
    service: 'savedSheets',
    title: 'sheets'
  });

  // This is the only thing that gets injected into controllers
  module.service('savedSheets', function (SavedSheet, kbnIndex, kbnUrl, Private, $http) {
    // kibi: added options for SavedObjectLoader
    const options = {
      caching: {
        find: true,
        get: true,
        cache: Private(CacheProvider)
      },
      $http
    };
    const savedSheetLoader = new SavedObjectLoader(SavedSheet, kbnIndex, kbnUrl, options);
    savedSheetLoader.urlFor = function (id) {
      return kbnUrl.eval('#/{{id}}', { id: id });
    };

    savedSheetLoader.loaderProperties = {
      name: 'timelion-sheet',
      noun: 'Saved Sheets',
      nouns: 'saved sheets'
    };
    return savedSheetLoader;
  });
});
