'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

exports.default = function (kbnServer, server, config) {

  server.decorate('server', 'config', function () {
    return kbnServer.config;
  });

  for (const key of getUnusedSettings(kbnServer.settings, config.get())) {
    server.log(['warning', 'config'], `Settings for "${key}" were not applied, check for spelling errors and ensure the plugin is loaded.`);
  }
};

var _lodash = require('lodash');

var _transform_deprecations = require('./transform_deprecations');

const getUnusedSettings = (settings, configValues) => {
  return (0, _lodash.difference)((0, _lodash.keys)((0, _transform_deprecations.transformDeprecations)(settings)), (0, _lodash.keys)(configValues));
};

module.exports = exports['default'];
