'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports._String = undefined;

var _lodash = require('lodash');

var _lodash2 = _interopRequireDefault(_lodash);

var _string = require('../../../ui/public/utils/lodash-mixins/string');

var _field_format = require('./field_format');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

(0, _string.lodashStringMixin)(_lodash2.default);

class _String extends _field_format.FieldFormat {
  constructor(params) {
    super(params);
  }

  _base64Decode(val) {
    try {
      return Buffer.from(val, 'base64').toString('binary');
    } catch (e) {
      return _lodash2.default.asPrettyString(val);
    }
  }

  _toTitleCase(val) {
    return val.replace(/\w\S*/g, txt => {
      return txt.charAt(0).toUpperCase() + txt.substr(1).toLowerCase();
    });
  }

  _convert(val) {
    switch (this.param('transform')) {
      case 'lower':
        return String(val).toLowerCase();
      case 'upper':
        return String(val).toUpperCase();
      case 'title':
        return this._toTitleCase(val);
      case 'short':
        return _lodash2.default.shortenDottedString(val);
      case 'base64':
        return this._base64Decode(val);
      default:
        return _lodash2.default.asPrettyString(val);
    }
  }
}

exports._String = _String;
_String.id = 'string';
_String.title = 'String';
_String.fieldType = ['number', 'boolean', 'date', 'ip', 'attachment', 'geo_point', 'geo_shape', 'string', 'murmur3', 'unknown', 'conflict'];

_String.paramDefaults = {
  transform: false
};

_String.transformOpts = [{ id: false, name: '- none -' }, { id: 'lower', name: 'Lower Case' }, { id: 'upper', name: 'Upper Case' }, { id: 'title', name: 'Title Case' }, { id: 'short', name: 'Short Dots' }, { id: 'base64', name: 'Base64 Decode' }];

_String.sampleInputs = ['A Quick Brown Fox.', 'STAY CALM!', 'com.organizations.project.ClassName', 'hostname.net', 'SGVsbG8gd29ybGQ='];
