'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _fs = require('fs');

var _lodash = require('lodash');

var _utils = require('../../utils');

const CONFIG_PATHS = [process.env.CONFIG_PATH, (0, _utils.fromRoot)('config/investigate.yml') // kibi: use kibi configuration file
//'/etc/kibana/kibana.yml' kibi: no such config location in kibi
].filter(Boolean);

// kibi: use '/var/lib/kibi'
const DATA_PATHS = [process.env.DATA_PATH, (0, _utils.fromRoot)('data'), '/var/lib/kibi'].filter(Boolean);

function getConfig() {
  return findFile(CONFIG_PATHS);
}

function findFile(paths) {
  const availablePath = (0, _lodash.find)(paths, configPath => {
    try {
      (0, _fs.accessSync)(configPath, _fs.R_OK);
      return true;
    } catch (e) {
      //Check the next path
    }
  });
  return availablePath || paths[0];
}

exports.default = {
  getConfig, // kibi: check if kibi.yml exists and migrate if so
  getData: () => findFile(DATA_PATHS)
};
module.exports = exports['default'];
