'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _toPath = require('lodash/internal/toPath');

var _toPath2 = _interopRequireDefault(_toPath);

var _lodash = require('lodash');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports.default = async function (kbnServer, server, config) {
  const forcedOverride = {
    console: function (enabledInConfig) {
      return !config.get('elasticsearch.tribe.url') && enabledInConfig;
    }
  };

  const { plugins } = kbnServer;

  const forcedPlugins = (0, _lodash.get)(kbnServer, 'settings.siren.forcedPlugins') || [];
  for (const plugin of plugins) {
    if (config.get('plugins.loadForTests') === false && !forcedPlugins.includes(plugin.pkg.name)) {
      // kibi: check 'gremlin_server'
      if (plugin.pkg.name === 'gremlin_server' && kbnServer.settings.gremlin && kbnServer.settings.gremlin.enabled === false) {
        plugins.disable(plugin);
        // Delete gremlin config to avoid a warning message about unused configuration.
        delete kbnServer.settings.gremlin;
        continue;
      }
      // kibi: end

      // kibi: let's disable selected plugins. This is done for ui testing
      if ((0, _lodash.get)(kbnServer, 'settings.siren.disabledPlugins') && kbnServer.settings.siren.disabledPlugins.indexOf(plugin.pkg.name) > -1) {
        plugins.disable(plugin);
        continue;
      }
      // kibi: end

      const enabledInConfig = config.get([...(0, _toPath2.default)(plugin.configPrefix), 'enabled']);
      const hasOveride = forcedOverride.hasOwnProperty(plugin.id);
      if (hasOveride) {
        if (!forcedOverride[plugin.id](enabledInConfig)) {
          plugins.disable(plugin);
        }
      } else if (enabledInConfig === false) {
        plugins.disable(plugin);
      }

      // kibi: if there is no configuration for investigate_access_control then disable it
      if (plugin.pkg.name === 'investigate_access_control' && !config.get(...(0, _toPath2.default)(plugin.configPrefix))) {
        plugins.disable(plugin);
      }
    }
    // kibi: end
  }

  return;
};

module.exports = exports['default'];
