'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _version = require('../../utils/version');

var _lodash = require('lodash');

function compatibleWithKibana(kbnServer, plugin) {
  //core plugins have a version of 'kibana' and are always compatible
  if (plugin.kibanaVersion === 'kibana') return true;

  const pluginKibanaVersion = (0, _version.cleanVersion)(plugin.kibanaVersion);
  const kibanaVersion = (0, _version.cleanVersion)(kbnServer.version);

  return (0, _version.versionSatisfies)(pluginKibanaVersion, kibanaVersion);
}

exports.default = async function (kbnServer, server) {
  //because a plugin pack can contain more than one actual plugin, (for example x-pack)
  //we make sure that the warning messages are unique
  const warningMessages = new Set();
  const plugins = kbnServer.plugins;

  for (const plugin of plugins) {
    const version = plugin.kibanaVersion;
    const name = (0, _lodash.get)(plugin, 'pkg.name');

    if (!compatibleWithKibana(kbnServer, plugin)) {
      const message = `Plugin "${name}" disabled as it should be compatible with the Kibana version (${kbnServer.version})` + ` on which Investigate is based. Found incompatible plugin version "${version}".`;
      warningMessages.add(message);
      plugins.disable(plugin);
    }
  }

  for (const message of warningMessages) {
    server.log(['warning'], message);
  }

  return;
};

module.exports = exports['default'];
