'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

exports.default = function (kibana) {
  return new kibana.Plugin({
    require: [],
    id: 'clientside_compression',

    uiExports: {
      hacks: ['plugins/clientside_compression/clientside_compression'],
      injectDefaultVars: function (server, options) {
        return {
          clientsideCompression: {
            compression_enabled: options.compression_enabled,
            compression_threshold: options.compression_threshold,
            logging_enabled: options.logging_enabled
          }
        };
      }
    },
    config(Joi) {
      const { boolean, number, object } = Joi;

      return object({
        enabled: boolean().default(true),
        compression_enabled: boolean().default(false),
        compression_threshold: number().default(1024),
        logging_enabled: boolean().default(false)
      }).default();
    },
    init(server) {
      const config = server.config();
      const compressionEnabled = config.get('clientside_compression.compression_enabled');
      if (compressionEnabled) {
        // inject variable so the hack can know to apply the compression or not
        server.expose('decodeGzipCompressedBuffer', gzipDataBuffer => {
          try {
            const ungzippedDataAsString = _pako2.default.ungzip(gzipDataBuffer, { to: 'string' });
            return Buffer.from(ungzippedDataAsString, 'utf-8');
          } catch (e) {
            server.log(['debug', 'clientside_compression'], e);
          }
        });
      }
    }
  });
};

var _pako = require('pako');

var _pako2 = _interopRequireDefault(_pako);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

;

// Client side compression to speed up investigate over slow uplink
// E.g.:
// During graph browser operations the already optimized payloads are still on avarage 30KB each
// which over slow uplink can add a considerable amount of time to each request
// With client side compression enabled these payloads are reduced ~7 times
// Adding 500 nodes to the graph saves ~1.9MB in total

module.exports = exports['default'];
