'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.resolveCompatibilityStatusTests = undefined;

var _compatibility_status = require('../../utils/compatibility_status');

var _compatibility_status2 = _interopRequireDefault(_compatibility_status);

var _federate_version_parser = require('../../utils/federate_version_parser');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const COMPATIBILITY_MATRIX = Object.freeze({
  MIN_SUPPORTED: new _federate_version_parser.FederateVersionParser('5.6.10-10.1.1'),
  FEATURE_COMPLETE: new _federate_version_parser.FederateVersionParser('6.3.2-10.2.1'),
  TARGET: new _federate_version_parser.FederateVersionParser('6.7.2-10.3.0'),
  toString: function () {
    return ` | Min: ${this.MIN_SUPPORTED}, Feature Complete: ${this.FEATURE_COMPLETE}, Target: ${this.TARGET}`;
  }
});

const resolveCompatibilityStatusTests = [{
  input: ['5.6.9-10.2.0', COMPATIBILITY_MATRIX],
  expected: _compatibility_status2.default.TOO_OLD
}, {
  input: ['5.6.9-10.1.1', COMPATIBILITY_MATRIX],
  expected: _compatibility_status2.default.TOO_OLD
}, {
  input: ['5.6.9-10.0.0', COMPATIBILITY_MATRIX],
  expected: _compatibility_status2.default.TOO_OLD
}, {
  input: ['5.6.10-10.1.0', COMPATIBILITY_MATRIX],
  expected: _compatibility_status2.default.TOO_OLD
}, {
  input: ['6.5.4-10.1.0', COMPATIBILITY_MATRIX],
  expected: _compatibility_status2.default.TOO_OLD
}, {
  input: ['5.6.10-10.1.1', COMPATIBILITY_MATRIX],
  expected: _compatibility_status2.default.MIN_SUPPORTED
}, {
  input: ['5.6.10-11.1.1', COMPATIBILITY_MATRIX],
  expected: _compatibility_status2.default.MIN_SUPPORTED
}, {
  input: ['6.2.4-10.2.1', COMPATIBILITY_MATRIX],
  expected: _compatibility_status2.default.MIN_SUPPORTED
}, {
  input: ['6.5.4-10.1.1', COMPATIBILITY_MATRIX],
  expected: _compatibility_status2.default.MIN_SUPPORTED
}, {
  input: ['6.3.2-10.1.1', COMPATIBILITY_MATRIX],
  expected: _compatibility_status2.default.MIN_SUPPORTED
}, {
  input: ['6.6.6-10.3.0', COMPATIBILITY_MATRIX],
  expected: _compatibility_status2.default.FEATURE_COMPLETE
}, {
  input: ['6.6.6-10.4.0', COMPATIBILITY_MATRIX],
  expected: _compatibility_status2.default.FEATURE_COMPLETE
}, {
  input: ['6.6.6-10.2.4', COMPATIBILITY_MATRIX],
  expected: _compatibility_status2.default.FEATURE_COMPLETE
}, {
  input: ['6.7.2-10.2.9', COMPATIBILITY_MATRIX],
  expected: _compatibility_status2.default.FEATURE_COMPLETE
}, {
  input: ['6.8.6-10.2.9', COMPATIBILITY_MATRIX],
  expected: _compatibility_status2.default.FEATURE_COMPLETE
}, {
  input: ['6.7.2-10.3.0', COMPATIBILITY_MATRIX],
  expected: _compatibility_status2.default.TARGET
}, {
  input: ['6.7.2-10.4.0', COMPATIBILITY_MATRIX],
  expected: _compatibility_status2.default.TARGET
}, {
  input: ['6.8.2-10.3.0', COMPATIBILITY_MATRIX],
  expected: _compatibility_status2.default.TARGET
}, {
  input: ['6.8.2-10.4.0', COMPATIBILITY_MATRIX],
  expected: _compatibility_status2.default.TARGET
}, {
  input: ['7.7.2-10.3.0', COMPATIBILITY_MATRIX],
  expected: _compatibility_status2.default.TOO_HIGH
}, {
  input: ['6.7.2-11.3.0', COMPATIBILITY_MATRIX],
  expected: _compatibility_status2.default.TOO_HIGH
}, {
  input: ['7.7.2-11.3.0', COMPATIBILITY_MATRIX],
  expected: _compatibility_status2.default.TOO_HIGH
}];

exports.resolveCompatibilityStatusTests = resolveCompatibilityStatusTests;
