'use strict';

var _federate_version_parser = require('./data/federate_version_parser');

var _errors = require('../errors');

var _federate_version_parser2 = require('../federate_version_parser');

describe('FederateVersionParser', () => {
  describe('isValid', () => {
    _federate_version_parser.isValidTests.forEach(test => {
      it(`test input: ${test.input}`, () => expect(_federate_version_parser2.FederateVersionParser.isValid(test.input)).toBe(test.expected));
    });
  });

  describe('retrieveElasticsearchAndFederateVersions', () => {
    _federate_version_parser.retrieveElasticsearchAndFederateVersionsTests.forEach(test => {
      it(`test input: ${test.input}`, () => expect(_federate_version_parser2.FederateVersionParser.retrieveElasticsearchAndFederateVersions(test.input)).toEqual(test.expected));
    });
    it('Throws error on invalid version', () => {
      expect(() => _federate_version_parser2.FederateVersionParser.retrieveElasticsearchAndFederateVersions('6.5.4-10.1.1.2')).toThrowError(_errors.InvalidFederateVersionError);
    });
  });

  describe('compareWith', () => {
    _federate_version_parser.compareWithTests.forEach(test => {
      it(`test input: ${test.input}`, () => {
        const compatibleVersion = new _federate_version_parser2.FederateVersionParser(test.input[0]);
        const versionDeployed = new _federate_version_parser2.FederateVersionParser(test.input[1]);
        expect(compatibleVersion.compareWith(versionDeployed)).toBe(test.expected);
      });
    });
  });
}); /* global expect */
