'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

exports.default = function (matrix, server) {
  server.log(['info', 'Investigate'], 'Federate Compatibility Matrix:');
  const table = new _cliTable2.default(TABLE_STYLE);
  table.push({ [headerColor('Support Level')]: headerColor('Federate Version') }, { [(0, _ansicolors.yellow)('Minimum')]: matrix.min_supported }, { [(0, _ansicolors.cyan)('Feature Complete')]: matrix.feature_complete }, { [(0, _ansicolors.green)('Target')]: matrix.target });
  console.log(table.toString());
};

var _ansicolors = require('ansicolors');

var _ansistyles = require('ansistyles');

var _cliTable = require('cli-table');

var _cliTable2 = _interopRequireDefault(_cliTable);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const headerColor = string => (0, _ansistyles.bright)((0, _ansicolors.white)(string));
const TABLE_STYLE = {
  chars: { 'top': '═', 'top-mid': '╤', 'top-left': '╔', 'top-right': '╗',
    'bottom': '═', 'bottom-mid': '╧', 'bottom-left': '╚', 'bottom-right': '╝',
    'left': '║', 'left-mid': '╟', 'mid': '─', 'mid-mid': '┼',
    'right': '║', 'right-mid': '╢', 'middle': '│' }
};

;
module.exports = exports['default'];
