'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

exports.default = function (kibana) {
  return new kibana.Plugin({
    require: ['kibana', 'elasticsearch'],
    id: 'image_proxy',
    init(server) {
      const config = server.config();
      if (config.get('investigate_core.image_proxy.enabled')) {
        (0, _image_proxy2.default)(server);
      }
    }
  });
};

var _image_proxy = require('./server/routes/image_proxy');

var _image_proxy2 = _interopRequireDefault(_image_proxy);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

;

/**
 * The image_proxy plugin return a stream from an image link in web, in the following form:
 *  GET /image_proxy?url={url}
 *
 * In investigate.yml is possible to set following parameters
 *  investigate_core.image_proxy.enabled - boolean to enable/disable the proxy, default to true
 *  investigate_core.image_proxy.allowed_domains - array of strings containing allowed domains, default to "*"
 *  investigate_core.image_proxy.max_image_size - number to set max image size allowed (in bytes), default to 10000
 *  investigate_core.image_proxy.timeout - number to set milliseconds before a request times out, default to 30sec
 *  investigate_core.image_proxy.proxy_cache_enabled - boolean to enable/disable the image proxy cache, default to false
 *  investigate_core.image_proxy.proxy_cache_expiration - number to set seconds of proxy cache duration, default to 3600sec.
 *  investigate_core.image_proxy.browser_cache_control - string to define browser Cache-Control, default to 'public, max-age=3600'
 *
 */
module.exports = exports['default'];
