'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.checkDomain = checkDomain;
/**
 * Check if domain is contained in allowedDomains, if allowedDomains contains '*' all the domain are available.
 *
 * @param {string} domain
 * @param {array} allowedDomains
 * @returns {boolean}
 */
function checkDomain(domain, allowedDomains) {
  if (!allowedDomains || !allowedDomains.length) {
    return false;
  }
  if (allowedDomains.indexOf('*') >= 0) {
    return true;
  }
  return RegExp('(' + allowedDomains.join('|') + ')').test(domain);
}
