'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.imageCache = imageCache;

var _lodash = require('lodash');

function imageCache(expiration) {

  let cache = {};

  function CacheHelper(expiration) {
    if (expiration > 0) {
      const self = this;
      setInterval(function () {
        self.invalidate();
      }, expiration);
    }
  }

  CacheHelper.prototype.set = function (key, value) {
    cache[key] = value;
  };

  // We need to clone the item before return the reference
  CacheHelper.prototype.get = function (key) {
    return cache[key] ? (0, _lodash.cloneDeep)(cache[key]) : null;
  };

  CacheHelper.prototype.invalidate = function () {
    cache = {};
  };

  const cacheHelperInstance = new CacheHelper(expiration);

  return cacheHelperInstance;
};
