'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _migration = require('kibiutils/lib/migrations/migration');

var _migration2 = _interopRequireDefault(_migration);

var _get_config_status = require('../../get_config_status/get_config_status');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Investigate Core - Migration 32.
 *
 * Looks if config object exists in kibana.index
 *
 * if not creates it in correct document format
 *
 * NOTE: these is needed to correctly support all following migrations on installations on top of kibana index
 *
 */

class Migration32 extends _migration2.default {

  constructor(configuration) {
    super(configuration);
    this._server = configuration.server;
    this._client = configuration.client;
    this._index = configuration.config.get('kibana.index');
    this._logger = configuration.logger;
  }

  static get description() {
    return 'Check if config object exists, if not create it';
  }

  async count() {
    try {
      const status = await (0, _get_config_status.getConfigStatus)(this._client, this._logger, this._index);
      if (status.exists === false) {
        return 1;
      }
    } catch (e) {
      this._logger.error('Not able to verify if config object exists', e);
    }
    return 0;
  }

  async upgrade() {
    try {
      const status = await (0, _get_config_status.getConfigStatus)(this._client, this._logger, this._index);
      if (status.exists === false) {
        if (status.documentFormat === 5) {
          await (0, _get_config_status.writeConfigInFormat5)(this._client, this._logger, this._index);
          return 1;
        } else if (status.documentFormat === 6) {
          await (0, _get_config_status.writeConfigInFormat6)(this._client, this._logger, this._index);
          return 1;
        } else {
          this._logger.warning('Unknown document format. Creating config object in document format 6');
          await (0, _get_config_status.writeConfigInFormat6)(this._client, this._logger, this._index);
          return 1;
        }
      }
    } catch (e) {
      this._logger.error('Not able to verify if config object exists', e);
    }
    return 0;
  }

}
exports.default = Migration32;
module.exports = exports['default'];
