import { management } from 'ui/management';
import { uiModules } from 'ui/modules';

import 'plugins/investigate_core/management/sections/data_model/services/data_model';
import 'plugins/investigate_core/management/sections/data_model/controllers/data_model_controller';
import 'plugins/investigate_core/management/sections/data_model/controllers/virtual_entity_create_controller';
import 'plugins/investigate_core/management/sections/data_model/controllers/edit_index_pattern_search_controller';

// to be able to reuse them on data model page
import 'plugins/kibana/management/sections/indices/create_index_pattern/create_index_pattern';
import createIndexPatternSearchTemplate from
  'plugins/kibana/management/sections/indices/create_index_pattern/create_index_pattern.html';
import createVirtualEntityTemplate from
  'plugins/investigate_core/management/sections/data_model/templates/create_virtual_entity.html';
import editIndexPatternSearchTemplate from
  'plugins/investigate_core/management/sections/data_model/templates/edit_index_pattern_search.html';


// this is a tric to include the existing templates without creating new scope
uiModules.get('kibana')
  .run(function ($templateCache) {
    $templateCache.put('create_index_pattern.html', createIndexPatternSearchTemplate);
    $templateCache.put('create_virtual_entity.html', createVirtualEntityTemplate);
    $templateCache.put('edit_index_pattern_search.html', editIndexPatternSearchTemplate);
  })
// borrowed from https://github.com/codenamezjames/angular-static-include/
  .directive('sirenStaticInclude', function ($templateRequest, $compile) {
    return {
      restrict: 'A',
      transclude: true,
      replace: true,
      scope: false,
      link: function ($scope, element, attrs, ctrl, transclude) {
        const templatePath = attrs.sirenStaticInclude;

        $templateRequest(templatePath)
          .then(function (response) {
            const contents = element.html(response).contents();
            $compile(contents)($scope.$new(false, $scope.$parent));
          });
      }
    };
  });

management.getSection('kibana').register('datamodel', {
  display: 'Data Model',
  order: 2,
  url: '#/management/siren/datamodel'
});
