import _ from 'lodash';
import { EntityType } from 'ui/kibi/components/ontology/entity_type';

function getTargetJoinDefinition(entity) {
  if (entity.type ===  EntityType.SAVED_SEARCH) {
    let pattern;
    try {
      pattern = entity._objects.indexPattern.title;
    } catch (e) {
      throw new Error('relations should be already augmented with _object.indexPattern data');
    }
    return pattern + '.' + entity.field;
  } else if (entity.type ===  EntityType.VIRTUAL_ENTITY) {
    return entity.id;
  }
}

// assume the entities in relations were already augmented with _object.indexPattern
export default function joinFields(relations, indexPatternId, fieldName) {

  const joinFields = _(relations).map(function (relation) {
    if (relation.domain.indexPattern === indexPatternId && relation.domain.field === fieldName) {
      return getTargetJoinDefinition(relation.range);
    }
    if (relation.range.indexPattern === indexPatternId && relation.range.field === fieldName) {
      return getTargetJoinDefinition(relation.domain);
    }
  }).compact().value();

  // Dedupe the values, as there are 2 directed relations per field.
  return _.uniq(joinFields, (value) => {
    return JSON.stringify(value);
  });
};
