import './_saved_relational_graph';
import { uiModules } from 'ui/modules';
import { SavedObjectLoader } from 'ui/courier/saved_object/saved_object_loader';
import { CacheProvider } from 'ui/kibi/helpers/cache_helper';
import { savedObjectManagementRegistry } from 'plugins/kibana/management/saved_object_registry';

// Register this service with the saved object registry so it can be
// edited by the object editor.
savedObjectManagementRegistry.register({
  service: 'savedRelationalGraphs',
  title: 'relational model graphs'
});

// kibi: added Private
uiModules
  .get('plugins/graph_browser_vis/settings/saved_relational_graphs')
  .service('savedRelationalGraphs', function (Private, SavedRelationalGraph, kbnIndex, kbnUrl, $http) {
    const options = {
      caching: {
        find: true,
        get: true,
        cache: Private(CacheProvider)
      },
      $http,
      mapHit(source) {
        for (const attr of ['model']) {
          if (source[attr]) {
            source[attr] = JSON.parse(source[attr]);
          }
        }
      },
      exclude: ['relational-graph']
    };
    const savedRelationalGraphLoader = new SavedObjectLoader(SavedRelationalGraph, kbnIndex, kbnUrl, options);
    // Customize loader properties since adding an 's' on type doesn't work for type 'eid' .
    savedRelationalGraphLoader.loaderProperties = {
      name: 'Relational Model Graph',
      noun: 'Relational Model Graph',
      nouns: 'Relational Model Graphs'
    };

    savedRelationalGraphLoader.urlFor = function (id) {
      return kbnUrl.eval('#/management/siren/objects/savedRelationalGraphs/{{id}}', { id: id });
    };

    return savedRelationalGraphLoader;
  });
