import { SavedObjectLoader } from 'ui/courier/saved_object/saved_object_loader';

export default class SavedScriptLoader extends SavedObjectLoader {

  // available types: ["expansion", "contextual", "onGraphUpdate", "lens"]
  findByType(type) {
    if (!this.isSupportedScriptType(type)) {
      return Promise.resolve([]);
    } else {

      // cache the results of this method
      const cacheKey = 'savedTypeScripts' + type;
      if (this.cache && this.cacheFind && this.cache.get(cacheKey)) {
        return Promise.resolve(this.cache.get(cacheKey));
      } else {
        return this.savedObjectsClient.find({
          type: 'script',
          searchFields: ['type'],
          search: type,
          perPage: 10000
        })
          .then(result => {
            const mapped = {
              total: result.total,
              hits: result.savedObjects.map((savedObject) => this.mapSavedObjectApiHits(savedObject))
            };
            this.cache.set(cacheKey, mapped);
            return mapped;
          });
      }
    }
  }

  // available types: ["expansion", "contextual", "onGraphUpdate", "lens"]
  getCountByType(type) {
    if (!this.isSupportedScriptType(type)) {
      return Promise.resolve(0);
    } else {
      return this.findByType(type)
        .then(resultType => {
          return resultType.total;
        });
    }
  }

  // available types: ["expansion", "contextual", "onGraphUpdate", "lens"]
  isSupportedScriptType(type) {
    return !!(type === 'expansion' || type === 'contextual' || type === 'onGraphUpdate' || type === 'lens' || type === 'watcher');
  }

}
