import 'fontawesome-iconpicker';
import { forIn } from 'lodash';
import { uiModules } from 'ui/modules';

uiModules
  .get('kibana')
  .directive('iconPicker', function ($window) {
    return {
      restrict: 'A',
      scope: {
        ngModel: '=',
        customStyles: '='
      },
      link($scope, $element, attrs) {
        $element.iconpicker({
          inputSearch: true,
          hideOnSelect: true,
          placement: 'bottomLeft'
        });

        const clickFocusHandler = () => {
          if (!$window.getSelection().toString()) {
            $element.select();
          }
          if ($scope.customStyles) {
            const iconPicker = (document.getElementsByClassName("iconpicker-popover popover fade bottomLeft in"))[0];
            forIn($scope.customStyles, function (value, key) {
              iconPicker.style[key] = value;
            });
          }
        };

        const iconpickerSelectHandler = (item) => {
          $scope.$apply(() => {
            $scope.ngModel = item.iconpickerItem.data().iconpickerValue;
          });
        };

        $scope.$watch('ngModel', (newVal, oldVal) => {
          if (newVal !== oldVal) {
            $element.data('iconpicker').setSourceValue(newVal.toLowerCase());
          }
        });

        $element.on('click focus', clickFocusHandler);
        $element.on('iconpickerSelect', iconpickerSelectHandler);

        $scope.$on('$destroy', () => {
          $element.off('click focus', clickFocusHandler);
          $element.off('iconpickerSelect', iconpickerSelectHandler);
          $element.data('iconpicker').destroy();
        });
      }
    };
  });
