import _ from 'lodash';
import getObjectValueFromDotNotation from '../../../lib/get_object_value_from_dot_notation';
export default function IndexOptionsHelperFactory(Promise, es, createNotifier) {

  // Method taken from /query_engine/lib/query_helper.js
  const _getValue = function (hit, group) {
    // do not make this global as it has to be reused inside a single call of this method
    // if you make it global the regex.lastIndex property will be set every time the regex is used
    // leading to unexpected results on subsequent calls
    const getValueRegex = /(\[[^\[\]].*?\])/g;

    let value = null;

    let match = getValueRegex.exec(group);
    let i = 1;
    while (match !== null) {
      let propertyName =  match[1];
      // strip brackets
      propertyName = propertyName.substring(1, propertyName.length - 1);
      if (i === 1) {
        value = hit[propertyName];
      } else if (!(typeof (value[propertyName]) === 'undefined' || value[propertyName] === null)) {
        value = value[propertyName];
      } else {
        // The property was not found, so we add an empty string
        value = '';
      }
      i++;
      match = getValueRegex.exec(group);
    }
    return value;
  };

  // Method taken from /query_engine/lib/query_helper.js
  const _evaluateParameterizedString = function (parameterizedLabel, hit) {
    // do not make this global as it has to be reused inside a single call of this method
    // if you make it global the regex.lastIndex property will be set every time the regex is used
    // leading to unexpected results on subsequent calls
    const parameterizedRegex = /(@doc\[.+?\]@)/g;

    let ret = parameterizedLabel;
    let match = parameterizedRegex.exec(parameterizedLabel);

    while (match !== null) {
      let group = match[1];
      group = group.replace('@doc', '');
      group = group.substring(0, group.length - 1);

      const value = _getValue(hit, group);

      // Escape special characters
      const reGroup = match[1].replace(/([.*+?^=!:${}()|\[\]\/\\])/g, '\\$1');
      const re = new RegExp(reGroup, 'g');
      ret = ret.replace(re, value);

      match = parameterizedRegex.exec(parameterizedLabel);
    }

    ret = ret.split('\\n').join('\n');
    return ret;
  };

  const notify = createNotifier({
    location: 'Siren Entity Options Helper'
  });

  class IndexOptionsHelper {

    getInstanceLabelPreviewContent(instanceLabel, indexPatternTitle, query = { match_all: {} }, size = 10) {
      if (instanceLabel && instanceLabel.value && indexPatternTitle) {
        const request = {
          index: indexPatternTitle,
          body: {
            size,
            query
          }
        };
        return es.search(request)
          .then((results) => {
            let html = '';
            if (results.hits && results.hits.hits) {
              if (results.hits.hits.length === 0) {
                html += '<table><tr><th>No results. Check queries, filters or time range.</th></tr></table>';
                return html;
              }

              html += '<table>';
              html += '  <tr><th>Document id</th><th>Label</th></tr>';
              _.each(results.hits.hits, (hit) => {
                html += '  <tr>';
                html += '    <td>' + hit._id + '</td>';

                if (instanceLabel.type === 'FIELD') {
                  let srcValue = hit._source;
                  if (instanceLabel.value) {
                    srcValue = getObjectValueFromDotNotation(srcValue, instanceLabel.value);
                  }
                  if (_.isObject(srcValue)) {
                    srcValue = JSON.stringify(srcValue);
                  }
                  html += '    <td>' + srcValue + '</td>';
                } else {
                  html += '    <td>' + _evaluateParameterizedString(instanceLabel.value, hit) + '</td>';
                }
                html += '</tr>';
              });
              html += '</table>';
            }
            return html;
          })
          .catch(err => {
            notify.error(err);
            return Promise.reject(err);
          });
      } else {
        return Promise.resolve('nothing to show');
      }
    };
  };

  return new IndexOptionsHelper();
};
