import { each, isObject, cloneDeep } from 'lodash';
export default (srcObj, stringDotNotation) => {
  //Return object value from string dot notation
  //For instance if stringDotNotation = 'geo.coordinates'
  //then return value of srcObj.geo.coordinates
  //Note that if srcObj.geo.coordinates not exists return srcObj.geo
  //but if also srcObj.geo not exists return undefined
  let retObj = cloneDeep(srcObj);
  const vals = stringDotNotation.split('.');
  let dotFound = false;
  each(vals, (val) => {
    if (isObject(retObj) && retObj[val] !== undefined) {
      retObj = retObj[val];
      dotFound = true;
    }
  });
  if (!dotFound) {
    return undefined;
  }
  return retObj;
};
