import { VisVisTypeProvider } from 'ui/vis/vis_type';
import { TemplateVisTypeProvider } from 'ui/template_vis_type/template_vis_type';
// we need to load the css ourselves
import 'plugins/kibi_data_table_vis/kibi_data_table_vis.less';
// we also need to load the controller and used by the template
import 'plugins/kibi_data_table_vis/kibi_data_table_vis_controller';
// our params are a bit complex so we will manage them with a directive
import 'plugins/kibi_data_table_vis/kibi_data_table_vis_params';
// register the provider with the visTypes registry
import { VisTypesRegistryProvider } from 'ui/registry/vis_types';
import _ from 'lodash';
import { toJson } from 'angular';
import template from 'plugins/kibi_data_table_vis/kibi_data_table_vis.html';
import 'plugins/kibi_data_table_vis/custom_view/kibi_custom_view';
import 'plugins/kibi_data_table_vis/custom_view/kibi_table_sorting';

VisTypesRegistryProvider.register(KibiDataTableVisTypeProvider);

function KibiDataTableVisTypeProvider(Private, config) {
  const VisType = Private(VisVisTypeProvider);
  const TemplateVisType = Private(TemplateVisTypeProvider);

  // return the visType object, which kibana will use to display and configure new
  // Vis object of this type.
  return new TemplateVisType({
    name: 'kibi-data-table',
    title: 'Record Table',
    icon: 'fa-th',
    category: VisType.CATEGORY.INDIVIDUAL,
    description: 'Use this to show the individual records of a search as a list. Can also use templates.',
    dashboard360Compatible: true,
    template,
    params: {
      defaults: {
        clickOptions: [],
        queryDefinitions: [],
        columns: [],
        customColumnAliases: [],
        disableTimeField: false,
        pageSize: config.get('discover:sampleSize')
      },
      editor: '<kibi-data-table-vis-params></kibi-data-table-vis-params>'
    },
    delegateSearch: true,
    init: function (vis, savedSearch) {
      if (!vis.params.pageSize) {
        vis.params.pageSize = config.get('discover:sampleSize');
      }

      if (savedSearch) {
        if (!vis.params.columns.length) {
          vis.params.columns = _.clone(savedSearch.columns);
        }

        const uiState = JSON.parse(this.uiStateJSON); // init method is called with this set to the saved visualization
        if (!uiState.sort) {
          uiState.sort = _.clone(savedSearch.sort);
          this.uiStateJSON = toJson(uiState);
        }

        vis.savedSearchId = savedSearch.id;
      }
    },
    version: 2
  });
}

export default KibiDataTableVisTypeProvider;
