import * as columnsActions from './actions/columns';
import { moveColumnMinWidth, moveNoWordWrap } from 'ui/doc_table/actions/columns';
import _ from 'lodash';
import 'ui/kibi/directives/kibi_select';
import 'ui/kibi/directives/kibi_select_dashboard';
import 'ui/kibi/directives/kibi_array_param';
import { uiModules } from 'ui/modules';
import template from 'plugins/kibi_data_table_vis/kibi_data_table_vis_params.html';

uiModules
  .get('kibana/kibi_data_table_vis')
  .directive('kibiDataTableVisParams', function (savedDatasources, $rootScope, $route, createNotifier, kbnUrl, config) {
    const notify = createNotifier({
      location: 'Enhanced search results'
    });

    return {
      restrict: 'E',
      template,
      link: function ($scope) {
      // ======
      // Events
      // ======

        const removeColumnAddListener = $rootScope.$on('kibi:column:add', (event, columnName) => {
          columnsActions.addColumn($scope.vis.params, columnName);
          // force the editable vis to be staged
          // this is needed because both the vis and the editableVis got already updated and so the visualization is not flagged as dirty
          $rootScope.$emit('stageEditableVis');
        });

        const removeColumnRemoveListener = $rootScope.$on('kibi:column:remove', (event, columnName) => {
          columnsActions.removeColumn($scope.vis.params, columnName);
          $rootScope.$emit('stageEditableVis');
        });



        const removeColumnMoveListener = $rootScope.$on('kibi:column:move', (event, columnName, newIndex) => {
          if ($scope.vis.params.customizeColumns) {
            moveColumnMinWidth($scope.vis.params.columns, columnName, newIndex, $scope.vis.params.customColumnMinWidth);
            moveNoWordWrap($scope.vis.params.columns, columnName, newIndex, $scope.vis.params.customColumnWordWrap);
          }
          columnsActions.moveColumn($scope.vis.params, columnName, newIndex);
          $rootScope.$emit('stageEditableVis');
        });

        const removeRemoveClickOptionsListener = $rootScope.$on('removeClickOptions', (event, columnName) => {
          _.remove($scope.vis.params.clickOptions, 'columnField', columnName);
        });

        $scope.$on('$destroy', function () {
          removeColumnAddListener();
          removeColumnRemoveListener();
          removeColumnMoveListener();
          removeRemoveClickOptionsListener();
        });

        // ===========
        // custom view
        // ===========

        $scope.jumpToTemplate = function () {
          kbnUrl.change('/management/siren/templates/' + $scope.vis.params.templateId);
        };

        $scope.filterTemplates = function (item) {
          return item ? item.templateEngine !== 'html-angular' : true;
        };

        // ==============
        // Column Aliases
        // ==============

        $scope.$watchCollection('vis.params.columns', columns => {
          populateColumnAliases();
        });

        $scope.columnAliasesValidation = function () {
          if (!$scope.aliasValidStatus) {
            $scope.aliasValidStatus = [];
          }
          $scope.columnAliasesValid = true;
          _.each($scope.vis.params.customColumnAliases, function (alias, index) {
            $scope.aliasValidStatus[index] = true;
            const count = _.sum($scope.vis.params.customColumnAliases, alias2 => alias === alias2);
            if (count > 1) {
              $scope.aliasValidStatus[index] = false;
              $scope.columnAliasesValid = '';
            }
          });
        };
        $scope.columnAliasesValidation();

        function populateColumnAliases() {
        // prepopulate aliases to original names if not defined
          _.each($scope.vis.params.columns, (columnName, index) => {
            if (!$scope.vis.params.customColumnAliases[index]) {
              $scope.vis.params.customColumnAliases[index] = columnName;
            }
          });
          $scope.columnAliasesValidation();
        }

        $scope.$watch('vis.params.customizeColumns', customizeColumns => {
          if (customizeColumns) {
            populateColumnAliases();
          } else {
            $scope.vis.params.customColumnAliases = [];
            $scope.vis.params.customColumnMinWidth = [];
            $scope.vis.params.customColumnWordWrap = _.fill(new Array($scope.vis.params.columns.length), false);
          }
        });

        $scope.$watch('vis.params.moreLikeThisTemplate', moreLikeThisTemplate => {
          if (!moreLikeThisTemplate) {
          // set the default options
            $scope.vis.params.moreLikeThisTemplate = JSON.stringify({
              max_query_terms : 25,
              min_term_freq : 1,
              max_doc_freq: 0,
              min_word_length: 0,
              max_word_length: 0,
              stop_words: [],
              analyzer: undefined
            }, null, ' ');
          }
        });

        // ==============
        // Click handlers
        // ==============

        // holds option validation status
        $scope.clickHandlerValidationStates = [];

        // Initialise the clicks parameters.
        const clickHandlersChanged = $scope.clickHandlersChanged = function () {
          _.each($scope.vis.params.clickOptions, function (clickOption, ind) {
            if (!clickOption.uriFormat && clickOption.type === 'link') {
              clickOption.uriFormat = '@URL@';
            }
          });
        };

        /**
       * Checks if any column has two or more of the same click action
       */
        const _checkForDuplicates = function () {
          $scope.clickHandlerValidationStates.length = 0;
          _.each($scope.vis.params.clickOptions, function (clickOption) {
            $scope.clickHandlerValidationStates.push({
              state: 'valid',
              message: ''
            });
          });

          _.chain($scope.vis.params.clickOptions)
            .countBy(function (clickOption, ind) {
              return clickOption.type + '$#%' + clickOption.columnField;
            })
            .each(function (count, key) {
              if (count !== 1) {
                const parts = key.split('$#%');
                const msg = 'You cannot have more than one action of the same type on a same column: ' +
                      'found ' + count + ' ' + parts[0] + ' actions on the column ' + parts[1];
                notify.warning(msg);
                _.each($scope.vis.params.clickOptions, function (clickOption, index) {
                  if (clickOption.type === parts[0] && clickOption.columnField === parts[1]) {
                    $scope.clickHandlerValidationStates[index].message = msg;
                    $scope.clickHandlerValidationStates[index].state = '';
                  }
                });
              }
            })
            .value();
        };

        $scope.$watch('vis.params.clickOptions', function () {
          clickHandlersChanged();
          _checkForDuplicates();
        }, true);
      }
    };
  })
  .directive('forceDirty', function () {
    return {
      require: 'ngModel',
      link: function (scope, elm, attrs, ctrl) {
        ctrl.$validators.noDuplicates = function (modelValue, viewValue) {
          if (viewValue) {
            return true;
          }
          ctrl.$setDirty();
          return false;
        };
      }
    };
  });
