import { VisVisTypeProvider } from 'ui/vis/vis_type';
import { TemplateVisTypeProvider } from 'ui/template_vis_type/template_vis_type';
// register the provider with the visTypes registry
import { VisTypesRegistryProvider } from 'ui/registry/vis_types';

VisTypesRegistryProvider.register(KibiSequentialJoinVisTypeProvider);

function KibiSequentialJoinVisTypeProvider(Private) {
  const VisType = Private(VisVisTypeProvider);
  const TemplateVisType = Private(TemplateVisTypeProvider);

  // return the visType object, which kibana will use to display and configure new
  // Vis object of this type.
  return new TemplateVisType({
    name: 'kibi_sequential_join_vis',
    title: 'Relational Filter',
    icon: 'fa-arrows-alt-h',
    category: VisType.CATEGORY.INTERACTIVE_FILTERS_RELATIONAL_NAVIGATION,
    description: 'DEPRECATED, use Relational Navigator instead. Will be removed soon.',
    template: `
      <div style="display: flex; align-items: center; justify-content: center; width: 100%">
        <i style="text-align: center">
          The Relational Filter visualization is no longer supported. Please use the 
          <a href="#/visualize/create?type=siren_auto_join_vis">Relational Navigator</a> instead.
        </i>
      </div>
    `,
    requiresSearch: false,
    disableCreation: true,
    version: 2
  });
}

// export the provider so that the visType can be required with Private()
export default KibiSequentialJoinVisTypeProvider;
