'use strict';

var _kibiutils = require('kibiutils');

var _kibiutils2 = _interopRequireDefault(_kibiutils);

var _rest_datasource_def = require('./rest_datasource_def');

var _rest_datasource_def2 = _interopRequireDefault(_rest_datasource_def);

var _jdbc_new_datasource_def = require('./jdbc_new_datasource_def');

var _jdbc_new_datasource_def2 = _interopRequireDefault(_jdbc_new_datasource_def);

var _datasources = require('../../../investigate_core/public/management/sections/kibi_datasources/lib/datasources');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

module.exports = function (server, datasource) {

  switch (datasource.datasourceType.toLowerCase()) {
    case 'mysql':
    case 'postgresql':
    case 'sqlite':
    case 'sparql_http':
    case _kibiutils2.default.DatasourceTypes.rest:
      datasource.datasourceClazz = new _rest_datasource_def2.default(server, datasource);
      break;
    case _datasources.DatasourceTypes.JDBC:
      datasource.datasourceClazz = new _jdbc_new_datasource_def2.default(server, datasource);
      break;
    default:
      datasource.datasourceClazz = null;
      server.log(['error', 'set_datasource_clazz'], 'Unknown datasource [' + datasource.datasourceType + ']');
  }
};
