'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.translateToES = translateToES;
function translateToES(server, req, query) {
  const serverConfig = server.config();
  return server.plugins.elasticsearch.getQueriesAsPromise(Buffer.from(query)).map(query => {
    let credentials = null;
    if (serverConfig.has('xpack.security.cookieName')) {
      credentials = req.state[serverConfig.get('xpack.security.cookieName')];
    }
    if (req.auth && req.auth.credentials && req.auth.credentials.proxyCredentials) {
      credentials = req.auth.credentials.proxyCredentials;
    }
    return server.plugins.elasticsearch.dbfilter(server.plugins.query_engine.getQueryEngine(), query, credentials);
  }).map(query => server.plugins.elasticsearch.sirenJoinSet(query)).map(query => server.plugins.elasticsearch.sirenJoinSequence(query)).then(data => {
    return data[0];
  });
}
