'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _base = require('./base');

var _base2 = _interopRequireDefault(_base);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Thrown when an object is not found.
 */
class NotFoundError extends _base2.default {
  /**
   * Creates a new NotFoundError.
   *
   * @param {string} message - The error message.
   * @param {Error} inner - An optional error that caused the NotFoundError.
   */
  constructor(message, inner) {
    super(message, inner);
    this.name = 'NotFoundError';
  }
}
exports.default = NotFoundError;
module.exports = exports['default'];
