import _ from 'lodash';

export function AggResponseBucketsProvider() {
  function Buckets(aggResp, aggParams) {
    aggResp = aggResp || false;
    this.buckets = aggResp.buckets || [];
    this.objectMode = _.isPlainObject(this.buckets);

    if (this.objectMode) {
      this._keys = _.keys(this.buckets);
      this.length = this._keys.length;
    } else {
      this.length = this.buckets.length;
    }
    if (this.length && aggParams) this._orderBucketsAccordingToParams(aggParams);
  }

  Buckets.prototype.forEach = function (fn) {
    const buckets = this.buckets;

    if (this.objectMode) {
      this._keys.forEach(function (key) {
        fn(buckets[key], key);
      });
    } else {
      buckets.forEach(function (bucket) {
        fn(bucket, bucket.key);
      });
    }
  };

  Buckets.prototype._orderBucketsAccordingToParams = function (params) {
    if (params.filters && this.objectMode) {
      this._keys = params.filters.map(filter => {
        const query = _.get(filter, 'input.query.query_string.query', filter.input.query);
        const queryString = typeof query === 'string' ? query : JSON.stringify(query);
        return filter.label || queryString || '*';
      });
    } else if (params.ranges && this.objectMode) {
      this._keys = params.ranges.map(range => {
        return _.findKey(this.buckets, el => el.from === range.from && el.to === range.to);
      });
    } else if (params.ranges && params.field.type !== 'date') {
      let ranges = params.ranges;
      if (params.ipRangeType) {
        ranges = params.ipRangeType === 'mask' ? ranges.mask : ranges.fromTo;
      }
      this.buckets = ranges.map(range => {
        if (range.mask) return this.buckets.find(el => el.key === range.mask);
        return this.buckets.find(el => el.from === range.from && el.to === range.to);
      });
    }
  };

  return Buckets;
}
