import _ from 'lodash';
// kibi: #5647 backport of missing and others in term aggregations - Start
import { getConvertedValueForField } from 'ui/filter_manager/lib/phrase';

export function migrateFilter(filter, indexPattern) {
// kibi: #5647 backport of missing and others in term aggregations - End
  if (filter && filter.match) {
    const fieldName = Object.keys(filter.match)[0];


    if (isMatchPhraseFilter(filter, fieldName)) {
      const params = _.get(filter, ['match', fieldName]);
      // kibi: #5647 backport of missing and others in term aggregations - Start
      if (_.get(indexPattern, ['fields'])) {
        const field = indexPattern.fields.find(f => f.name === fieldName);
        if (field) {
          params.query = getConvertedValueForField(field, params.query);
        }
      }
      // kibi: #5647 backport of missing and others in term aggregations - End
      return {
        match_phrase: {
          [fieldName]: _.omit(params, 'type'),
        },
      };
    }
  } else if (_.get(filter, ['bool', 'should'])) {
    filter.bool.should = filter.bool.should.map(migrateFilter);
  }

  return filter;
}

function isMatchPhraseFilter(filter, fieldName) {
  return _.get(filter, ['match', fieldName, 'type']) === 'phrase';
}
