/*eslint no-use-before-define: 0*/
import jQuery from 'jquery';
import _ from 'lodash';
import { RegistryFieldFormatsProvider } from 'ui/registry/field_formats';
import { DecorateQueryProvider } from 'ui/courier/data_source/_decorate_query';
import 'kibi-qtip2';
import { uiModules } from 'ui/modules';
// kibi: added to collect all non-meta fields from all index patterns
import { GetFieldsFromAllIndexPatternsProvider } from './lib/get_fields_from_all_index_patterns';
// kibi: end

uiModules
  .get('app/dashboard')
  .service('joinExplanation', ($timeout, Private, indexPatterns, Promise, kibiState) => {
    const fieldFormat = Private(RegistryFieldFormatsProvider);
    const decorateQuery = Private(DecorateQueryProvider);
    const getFieldsFromAllIndexPatterns = Private(GetFieldsFromAllIndexPatternsProvider);

    /**
   * Format the value as a date if the field type is date
   */
    function formatDate(fields, fieldName, value) {
    // kibi: if there is more than one field with the same name
    // could happen if index-pattern is not specified in the filter meta
      const possibleCandidateFields = _.filter(fields, function (field) {
        return field.name === fieldName && field.type === 'date';
      });
      if (possibleCandidateFields.length === 1) {
        const format = possibleCandidateFields[0].format ?
          possibleCandidateFields[0].format
          : fieldFormat.getDefaultInstance('date');
        return format.convert(value, 'html');
      } else {
        return value;
      };
    // kibi: end
    }

    function formatMatch(f, matchType) {
      const match = Object.keys(f[matchType])[0];
      const matchQuery = f[matchType][match];

      if (matchQuery.constructor === Object) {
        return ' match on ' + match + ': <b>' + matchQuery.query + '</b> ';
      } else {
        return ' match on ' + match + ': <b>' + matchQuery + '</b> ';
      }
    }

    const initQtip = function (explanations) {
      jQuery('.qtip-join').qtip('destroy', true);
      $timeout(function () {

        jQuery('.filter').each(function (index) {
          const $el = jQuery(this);
          if ($el.hasClass('join') && explanations[index]) {
            $el.qtip('destroy', true);
            $el.qtip({
              content: {
                title: 'Steps - last one on top',
                text: explanations[index]
              },
              position: {
                my: 'top left',
                at: 'bottom center'
              },
              style: {
                classes: 'qtip-join qtip-light qtip-rounded qtip-shadow'
              }
            });
          }
        });
      });
      return Promise.resolve('done');
    };

    const createFilterLabel = function (f, fields) {
      return createFilterLabelIgnoreMetaNegation(f, fields)
        .then(label => {
          if (f.meta && f.meta.negate) {
            return 'NOT' + label;
          }
          return label;
        });
    };

    // kibi: explanation for boolean filter
    function explainBooleanFilter(query, fields) {
      const boolPromises = [];
      const clause = query.should || query.must || query.must_not;

      // clause might contain an array of filters or a single filter object
      let filters = [clause];
      if (clause instanceof Array) {
        filters = clause;
      }

      filters.forEach(item => {
        boolPromises.push(createFilterLabelIgnoreMetaNegation(item, fields));
      });
      return Promise.all(boolPromises)
        .then(boolElements => {
          let html = '';
          if (query.should) {
            html += boolElements.join(' OR ');
          };
          if (query.must) {
            html += boolElements.join(' AND ');
          };
          if (query.must_not) {
            html += boolElements.map(element => ' NOT ' + element).join(' AND ');
          };
          if (boolElements.length > 1) {
            html = '(' + html + ')';
          }
          return html;
        });
    };
    // kibi: end

    const createFilterLabelIgnoreMetaNegation = function (f, fields) {
      let prop;
      let lowerBound;
      let upperBound;
      let lowerBoundDescriptor;
      let upperBoundDescriptor;

      if (f.query_string && f.query_string.query) {
        return Promise.resolve(' query: <b>' + f.query_string.query + '</b> ');
      } else if (f.terms) {
        const fieldName = Object.keys(f.terms)[0];
        return Promise.resolve(` any on ${fieldName}: <b>${f.terms[fieldName].join(', ')}</b> `);
      } else if (f.match) {
        return Promise.resolve(formatMatch(f, 'match'));
      } else if (f.match_phrase) {
        return Promise.resolve(formatMatch(f, 'match_phrase'));
      } else if (f.match_phrase_prefix) {
        return Promise.resolve(formatMatch(f, 'match_phrase_prefix'));
      } else if (f.match_all) {
        return Promise.resolve(' match all ');
      } else if (f.range) {
        prop = Object.keys(f.range)[0];
        lowerBound = _.has(f.range[prop], 'gte') ? f.range[prop].gte : f.range[prop].gt;
        upperBound = _.has(f.range[prop], 'lte') ? f.range[prop].lte : f.range[prop].lt;
        lowerBoundDescriptor = _.has(f.range[prop], 'gte') ? 'inclusive' : 'exclusive';
        upperBoundDescriptor = _.has(f.range[prop], 'lte') ? 'inclusive' : 'exclusive';
        return Promise.resolve(' ' + prop + ': <b>' + formatDate(fields, prop, lowerBound) +
        '</b> (' + lowerBoundDescriptor + ') to <b>' + formatDate(fields, prop, upperBound) +
        '</b> (' + upperBoundDescriptor + ') ');
      } else if (f.dbfilter) {
        return Promise.resolve(' ' + (f.dbfilter.negate ? 'NOT' : '') + ' dbfilter: <b>' + f.dbfilter.queryid + '</b> ');
      } else if (f.or) {
        return Promise.resolve(' or filter <b>' + f.or.length + ' terms</b> ');
      } else if (f.exists) {
        return Promise.resolve(' exists: <b>' + f.exists.field + '</b> ');
      } else if (f.script) {
        return Promise.resolve(' script: script:<b>' + f.script.script + '</b> params: <b>' + f.script.params + '</b> ');
      } else if (f.missing) {
        return Promise.resolve(' missing: <b>' + f.missing.field + '</b> ');
      } else if (f.not) {
        return createFilterLabelIgnoreMetaNegation(f.not, fields).then(function (html) {
          return ' NOT' + html;
        });
      } else if (f.geo_bounding_box) {
      // kibi: added rule to grab correct param for explanation
        const queryOptions = ['type', 'validation_method', '_name', 'ignore_unmapped'];
        prop = _.find(Object.keys(f.geo_bounding_box), key => queryOptions.indexOf(key) === -1);
        return Promise.resolve(' ' + prop + ': <b>' + JSON.stringify(f.geo_bounding_box[prop].top_left, null, '') + '</b> to <b>'
        + JSON.stringify(f.geo_bounding_box[prop].bottom_right, null, '') + '</b> ');
      // kibi: end
      } else if (f.join_sequence) {
        return explainJoinSequence(f.join_sequence).then(function (html) {
          return 'join_sequence: ' + html;
        });
      } else if (f.query) {
        return createFilterLabelIgnoreMetaNegation(f.query);
      } else if (f.bool) {
      // kibi: explanation for boolean filter
        return explainBooleanFilter(f.bool, fields);
      // kibi: end
      } else if (f.term) {
      // kibi: explanation for term filter
        prop = Object.keys(f.term)[0];
        return Promise.resolve(' ' + prop + ': <b>' + f.term[prop] + '</b> ');
      // kibi: end
      } else {
        return Promise.resolve(' <font color="red">Unable to pretty print the filter:</font> ' +
        JSON.stringify(_.omit(f, '$$hashKey'), null, ' ') + ' ');
      }
    };

    const explainFilter = function (filter, indexId) {
      if (filter.range || filter.not) {
      // fields might be needed
      // kibi: logic for undefined index and collecting all fields
        if (indexId || _.get(filter, 'meta.index')) {
          const indexPatternId = indexId ? indexId : filter.meta.index;
          return indexPatterns.get(indexPatternId).then(function (index) {
            return createFilterLabel(filter, index.fields);
          });
        } else {
          return getFieldsFromAllIndexPatterns().then(function (fields) {
            return createFilterLabel(filter, fields);
          });
        };
      // kibi: end
      } else {
        return Promise.resolve(createFilterLabel(filter));
      }
    };

    const explainFilterInMustNot = function (filter, indexId) {
      return explainFilter(filter, indexId).then(function (filterExplanation) {
        return ' NOT' + filterExplanation;
      });
    };

    const explainQueries = function (queries, indexId) {

      const promises = [];
      _.each(queries, function (query) {
      // in our case we have filtered query for now
        if (query.query && query.query.bool && query.query.bool.must) {
          let queryStrings = query.query.bool.must;
          if (!(query.query.bool.must instanceof Array)) {
            queryStrings = [ query.query.bool.must ];
          }
          _.each(queryStrings, (queryString) => {
          // only if the query is different than star query
            if (!_.has(queryString, 'query_string.query') || _.get(queryString, 'query_string.query') !== '*') {
              promises.push(explainFilter(queryString, indexId));
            }
          });
        }

        if (query.query && query.query.bool && query.query.bool.must_not) {
          let queryStrings = query.query.bool.must_not;
          if (!(query.query.bool.must_not instanceof Array)) {
            queryStrings = [ query.query.bool.must_not ];
          }
          _.each(queryStrings, (queryString) => {
          // only if the query is different than star query
            if (!_.has(queryString, 'query_string.query') || _.get(queryString, 'query_string.query') !== '*') {
              promises.push(explainFilterInMustNot(queryString, indexId));
            }
          });
        }

        if (query.query && query.query.bool && query.query.bool.filter && query.query.bool.filter.bool) {
          const must = query.query.bool.filter.bool.must;
          const mustNot = query.query.bool.must_not;
          if (must instanceof Array && must.length > 0) {
            _.each(must, function (filter) {
              promises.push(explainFilter(filter, indexId));
            });
          }
          if (mustNot instanceof Array && mustNot.length > 0) {
            _.each(mustNot, function (filter) {
              promises.push(explainFilterInMustNot(filter, indexId));
            });
          }
        }

        if (query.query_string && query.query_string.query) {
          promises.push(explainFilter(query, indexId));
        }
      });

      return Promise.all(promises).then(function (filterExplanations) {
        let html = '<ul>';
        _.each(filterExplanations, function (explanation) {
          html += '<li>' + explanation + '</li>';
        });
        return html + '</ul>';
      });
    };

    const explainRelation = function (el) {
      const relation = el.relation;

      const promises = [];
      if (relation[0].queries instanceof Array && relation[0].queries.length > 0) {
        promises.push(explainQueries(relation[0].queries, relation[0].pattern));
      } else {
        promises.push(Promise.resolve(''));
      }

      if (relation[1].queries instanceof Array && relation[1].queries.length > 0) {
        promises.push(explainQueries(relation[1].queries, relation[1].pattern));
      } else {
        promises.push(Promise.resolve(''));
      }

      return Promise.all(promises).then(function (explanations) {
        const html =
        '<b>' + (el.negate === true ? 'NOT ' : '') + 'Relation:</b></br>' +
        '<table class="relation">' +
        '<tr>' +
        '<td>from: <b>' + JSON.stringify(relation[0].indices, null, ' ') + '.' + relation[0].path + '</b>' +
        (explanations[0] ? '</br>' + explanations[0] : '') +
        '</td>' +
        '<td>to: <b>' + JSON.stringify(relation[1].indices, null, ' ') + '.' + relation[1].path + '</b>' +
        (explanations[1] ? '</br>' + explanations[1] : '') +
        '</td>' +
        '</tr></table>';

        return html;
      });
    };

    const explainJoinSequence = function (joinSequence, isPruned) {
    // clone and reverse to iterate backwards to show the last step on top
      const sequence = _.cloneDeep(joinSequence);
      sequence.reverse();

      const promises = [];
      _.each(sequence, function (el, i) {
        if (el.relation) {
          promises.push(explainRelation(el));
        } else if (el.group) {
          promises.push(explainGroup(el));
        }
      });

      return Promise.all(promises).then(function (sequenceElementExplanations) {
        let html = '<table class="sequence">';
        for (let i = 0; i < sequenceElementExplanations.length; i++) {
          html += '<tr' + (sequence[i].negate ? 'class="negated"' : '') + '><td>' + sequenceElementExplanations[i] + '</td></tr>';
        }

        if (isPruned) {
          html += '<tr><td><b>Notice:</b> This is a sample of the results because join operation was pruned</td></tr>';
        }
        return html + '</table>';
      });
    };

    const explainGroup = function (el) {
      const group = el.group;

      const promises = [];
      _.each(group, function (sequence, i) {
        promises.push(explainJoinSequence(sequence));
      });

      return Promise.all(promises).then(function (groupSequenceExplanations) {
        let html =
        '<b>Group of relations:</b></br>' +
        '<table class="group">';
        _.each(groupSequenceExplanations, function (sequenceExplanation) {
          html += '<tr><td>' + sequenceExplanation + '</td></tr>';
        });
        return html + '</table>';
      });
    };

    const wrapPromise = function (p) {
      return new Promise((resolve, reject) => {
        p
          .then(res => resolve(res))
          .catch(err => resolve(err.message));
      });
    };

    const getFilterExplanations = function (filters) {
      const promises = [];
      _.each(filters, function (f) {
        if (f.join_sequence) {
          if (f.meta && f.meta.isPruned) {
            promises.push(wrapPromise(explainJoinSequence(f.join_sequence, f.meta.isPruned)));
          } else {
            promises.push(wrapPromise(explainJoinSequence(f.join_sequence)));
          }
        } else {
          promises.push(wrapPromise(explainFilter(f)));
        }
      });

      return Promise.all(promises).then(function (results) {
        const filterExplanations = [];
        _.each(results, function (explanation) {
          filterExplanations.push(explanation);
        });

        return filterExplanations;
      });
    };


    const _appendExtra = function (queryExplanation, filterExplanation) {
      let html = '';
      if (queryExplanation) {
        html += queryExplanation + '<br/>';
      }
      if (filterExplanation && filterExplanation.length) {
        html += '<ul>';
        _.each(filterExplanation, function (explanation) {
        // TODO: new feature mark in some way filters from saved search
          html += '<li>' + explanation + '</li>';
        });
        html += '</ul>';
      }
      return html;
    };

    const _appendMissing = function (missingQueryExplanation, missingFiltersExplanation, timeDifferenceExplanation) {
      let html = '';
      if (missingQueryExplanation) {
        html += missingQueryExplanation;
      }
      if (missingFiltersExplanation && missingFiltersExplanation.length) {
        if (html.length > 0) {
          html += '<br/>';
        }
        html += '<ul>';
        _.each(missingFiltersExplanation, function (explanation) {
          html += '<li>' + explanation + '</li>';
        });
        html += '</ul>';
      }
      if (timeDifferenceExplanation) {
        if (html.length > 0) {
          html += '<br/>';
        }
        html += '<span>Time different from saved dashboard state:</span><br/>';
        html += '<span>' + timeDifferenceExplanation[0] + '</span>';
      }
      return html;
    };

    const _constructFilterIconMessage = function (filters, queries, time, diff) {
      const wildcardQuery = decorateQuery({
        query_string: {
          query: '*'
        }
      });

      if (queries || filters) {
        const nFilters = _.reject(filters, 'meta.fromSavedSearch').length;
        const hasQuery = !(kibiState._isDefaultQuery(queries[0]) || _.isEqual(queries[0], wildcardQuery));

        const filterExplanationPromise = nFilters ? getFilterExplanations(filters) : null;
        const missingFiltersExplanationPromise = (diff && diff.missing && diff.missing.filters) ?
          getFilterExplanations(diff.missing.filters) : null;

        const queryExplanationPromise = hasQuery ? explainQueries(queries) : null;
        const missingQueryExplanationPromise = (diff && diff.missing && diff.missing.query) ? explainQueries([diff.missing.query]) : null;

        const timeDifferenceExplanationPromise = (time && diff && diff.timeIsDifferent) ? getFilterExplanations([time]) : null;

        return Promise.all([
          queryExplanationPromise,
          filterExplanationPromise,
          missingFiltersExplanationPromise,
          missingQueryExplanationPromise,
          timeDifferenceExplanationPromise
        ])
          .then(([
            queryExplanation,
            filterExplanation,
            missingFiltersExplanation,
            missingQueryExplanation,
            timeDifferenceExplanation
          ]) => {
            let html = '';

            html += _appendExtra(queryExplanation, filterExplanation);

            if (missingQueryExplanation  || timeDifferenceExplanation || (missingFiltersExplanation && missingFiltersExplanation.length)) {
              html += '<br/><span class="siren-missing-saved-dash-states">Missing from saved dashboard state:<br/>';
              html += _appendMissing(missingQueryExplanation, missingFiltersExplanation, timeDifferenceExplanation);
              html += '</span>';
            }

            return html;
          });
      }
      return Promise.resolve(null);
    };

    return {
      constructFilterIconMessage: _constructFilterIconMessage,
      getFilterExplanations,
      createFilterLabel,
      initQtip: initQtip
    };
  });
