import _ from 'lodash';
import { FilterMetaPropertyIndexError, FilterMetaPropertyKeyError } from 'ui/errors';

export function FilterBarLibMapPhraseProvider(Promise, courier) {
  return function (filter) {
    const isScriptedPhraseFilter = isScriptedPhrase(filter);
    if (!_.has(filter, ['query', 'match']) && !isScriptedPhraseFilter) {
      return Promise.reject(filter);
    }

    return courier
      .indexPatterns
      .get(filter.meta.index)
      .then(function (indexPattern) {
        const type = 'phrase';
        const key = isScriptedPhraseFilter ? filter.meta.field : Object.keys(filter.query.match)[0];
        // kibi: handle case where fields are not present (indexPattern no longer exists);
        if (!indexPattern.fields) {
          return Promise.reject(new FilterMetaPropertyIndexError(filter.meta.index));
        }
        // kibi: end
        const field = indexPattern.fields.byName[key];
        // kibi: handle case where the field is no longer present in the index-pattern
        if (!field) {
          return Promise.reject(new FilterMetaPropertyKeyError(key, filter.meta.index));
        }
        // kibi: end
        const query = isScriptedPhraseFilter ? filter.script.script.params.value : filter.query.match[key].query;
        // kibi: added to make correct label for date fields with custom mapping
        let value = field.format.convert(query, null, field.mappingFormat);
        if (field.mappingFormat) {
          value += ' [' + field.mappingFormat + ']';
        };
        // kibi: end
        return { type, key, value };
      })
      .catch(err => {
        if (err instanceof FilterMetaPropertyIndexError || err instanceof FilterMetaPropertyKeyError) {
          return Promise.reject(err);
        }
        return Promise.reject(new FilterMetaPropertyIndexError(filter.meta.index));
      });
  };
}

function isScriptedPhrase(filter) {
  const params = _.get(filter, ['script', 'script', 'params']);
  return params && params.value;
}
