import { filter, find } from 'lodash';

function processNode(treeItems, node, depth) {
  node.depth = depth;

  const inLinks = filter(treeItems, item => {
    return item.type === 'link' && item.id2 === node.id;
  });

  for (const inLink of inLinks) {
    const connectedNode = find(treeItems, item => {
      return item.type === 'node' && item.id === inLink.id1;
    });
    processNode(treeItems, connectedNode, depth + 1);
  }
}


// we assume first node is the focused one
// for tree like
//
//      A*
//      |
//      ↓
//      B
//     / \
//    ↙   ↘
//   C     D
//
// the computed depths should be
//
//      A* depth = 0
//      |
//      ↓
//      B  depth = 1
//     / \
//    ↙   ↘
//   C     D depth = 2


export function addDepths(treeItems) {
  const initialDepth = 0;
  const node = treeItems[0];
  processNode(treeItems, node, initialDepth);
}
